package com.thebeastshop.scm.service;

import java.util.Arrays;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.thebeastshop.scm.dao.InvOccupyDao;
import com.thebeastshop.scm.dao.InvRcdDao;
import com.thebeastshop.scm.dao.PresaleDao;
import com.thebeastshop.scm.dao.ProductDao;
import com.thebeastshop.scm.dao.SkuCategoryFrontRelationDao;
import com.thebeastshop.scm.dao.SoPackageSkuDao;
import com.thebeastshop.scm.service.core.BaseService;

/**
 * 库存业务类
 */
@Component
public class StockService extends BaseService {

	@Resource private ProductDao productDao;
	@Resource private SkuCategoryFrontRelationDao skuCategoryFrontRelationDao;
	@Resource private PresaleDao presaleDao;
	@Resource private InvOccupyDao whInvOccupyDao;
	@Resource private InvRcdDao whInvRcdDao;
	@Resource private SoPackageSkuDao soPackageSkuDao;
	
	/**
	 * 公司总部code:CHN1001
	 * 鲜花固定仓
	 */
	private static final String FLOWER_WARE_HOUSE_CODE = "WH020600020002";
	
	/**
	 * 公司新官网code:CHN2018
	 * 鲜花固定仓
	 */
	private static final String NEW_WEBSITE_HOUSE_CODE = "WH020600010102";
	
	/**
	 * 得到野兽派新官网库存
	 */
	public int bySkuCode(String skuCode){
		List<String> skuCodeList = Arrays.asList(skuCode);
		return this.bySkuCode(skuCodeList);
	}
	
	/**
	 * 得到野兽派新官网库存
	 */
	public int byProductId(Integer productId){
		List<String> skuCodes = productDao.getSkuCodeById(productId);
		return this.bySkuCode(skuCodes);
	}

	private int bySkuCode(List<String> skuCodes){
		int presaleQuantity = presaleDao.getPresaleBySkuCodes(skuCodes);
		int salePresale = soPackageSkuDao.getQuantityBySkuCode(skuCodes);
		int presaleStock = presaleQuantity - salePresale;//预售数量 - 已卖出的预售数量
		if (presaleStock < 0) {
			log.warn("-------预售库存小于0,数据异常-------------------");
			presaleStock = 0;
		}
		String wareHouseCode = NEW_WEBSITE_HOUSE_CODE;
		//如果为类目为鲜花，去公司总部仓
		if (skuCategoryFrontRelationDao.isFlowerBySkuCode(skuCodes)) {
			wareHouseCode = FLOWER_WARE_HOUSE_CODE;
		}
		int invRcd = whInvRcdDao.getInvRcdQuantityBySkuCodeAndWareHouseCode(skuCodes, wareHouseCode);
		int invOccupy = whInvOccupyDao.getInvOccupyQuantityBySkuCodesAndWarehouseCode(skuCodes, wareHouseCode);
		//预售库存 + SKU库存记录 -SKU库存占用
		return presaleStock + invRcd - invOccupy;
	}
}