/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.LotteryActivityAward;
import com.thebeastshop.scm.po.LotteryActivityPrizeRecord;
import com.thebeastshop.scm.vo.lottery.LotteryActivityRecordVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="lottery_activity_prize_record")
public class LotteryActivityPrizeRecordDao
extends BaseDao<LotteryActivityPrizeRecord> {
    @Autowired
    public LotteryActivityPrizeRecordDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public LotteryActivityPrizeRecord save(Integer memberId, Integer lotteryActivityId, LotteryActivityAward lotteryActivityAward, String sysId) {
        LotteryActivityPrizeRecord lotteryActivityPrizeRecord = new LotteryActivityPrizeRecord();
        lotteryActivityPrizeRecord.setMemberId(memberId);
        lotteryActivityPrizeRecord.setLotteryActivityId(lotteryActivityId);
        lotteryActivityPrizeRecord.setSysId(sysId);
        lotteryActivityPrizeRecord.setCreateTime(new Date());
        if (lotteryActivityAward == null) {
            lotteryActivityPrizeRecord.setIsWin(Integer.valueOf(0));
            this.log.info("\u7528\u6237memberId:{} \u6ca1\u4e2d\u5956", (Object)memberId);
        } else {
            lotteryActivityPrizeRecord.setIsWin(Integer.valueOf(1));
            lotteryActivityPrizeRecord.setLotteryActivityAwardId(lotteryActivityAward.getId());
            this.log.info("\u7528\u6237memberId:{} \u4e2d\u5956\u4e86", (Object)memberId);
        }
        super.insert((IdPo)lotteryActivityPrizeRecord);
        return lotteryActivityPrizeRecord;
    }

    public Integer getDayCountByMemberIdAndLotteryActivityId(Integer memberId, Integer lotteryActivityId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberId", memberId);
        params.put("lotteryActivityId", lotteryActivityId);
        params.put("nowTime", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        return (Integer)super.selectOne("getDayCountByMemberIdAndLotteryActivityId", params);
    }

    public List<Map> winListByAwardId(Integer awardId) {
        return super.selectList("winListByAwardId", (Object)awardId);
    }

    public Integer bySysId(Integer memberId, Integer lotteryActivityId, String sysId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberId", memberId);
        params.put("lotteryActivityId", lotteryActivityId);
        params.put("sysId", sysId.trim());
        return (Integer)super.selectOne("bySysId", params);
    }

    public List<LotteryActivityRecordVO> getWinByMemberIdAndLotteryActivityId(Integer memberId, Integer lotteryActivityId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("isWin", 1);
        params.put("memberId", memberId);
        params.put("lotteryActivityId", lotteryActivityId);
        return super.selectList("getLotteryActivityRecordVO", params);
    }

    public List<LotteryActivityRecordVO> lastNewest(Integer limit) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("limitSize", limit);
        return super.selectList("getLotteryActivityRecordVO", params);
    }

    public LotteryActivityRecordVO getLotteryActivityRecordVOById(Integer lotteryActivityPrizeRecordId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("id", lotteryActivityPrizeRecordId);
        return (LotteryActivityRecordVO)super.selectOne("getLotteryActivityRecordVO", params);
    }
}

