/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.CampaignExcludeProduct;
import com.thebeastshop.scm.po.CampaignProduct;
import com.thebeastshop.scm.po.CategoryCampaign;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="campaign_product")
public class CampaignProductDao
extends BaseDao<CampaignProduct> {
    @Autowired
    public CampaignProductDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public CampaignProduct findCampaignProductBySkuCode(String skuCode, Long campaignId) {
        HashedMap params = new HashedMap();
        params.put("skuCode", skuCode);
        params.put("campaignId", campaignId);
        List campaignProductList = super.selectList("getLimitAmountBySkuCode", (Object)params);
        if (CollectionUtils.isNotEmpty((Collection)campaignProductList)) {
            return (CampaignProduct)campaignProductList.get(0);
        }
        return null;
    }

    public List<Long> getCategoryByCampaigns(List<Long> campaignIds) {
        return super.selectList("getCategoryByCampaigns", campaignIds);
    }

    public List<Long> getCategoryByAllCampaign() {
        return super.selectList("getCategoryByAllCampaign");
    }

    public List<Long> getCategoryByAllProgressCampaign() {
        return super.selectList("getCategoryByAllProgressCampaign");
    }

    public List<CategoryCampaign> getCategoryAndCampaigns(List<Long> categoryIds) {
        return super.selectList("getCategoryAndCampaigns", categoryIds);
    }

    public List<CampaignExcludeProduct> getCampaignExcludeProduct(List<Long> campaignIds) {
        return super.selectList("getCampaignExcludeProduct", campaignIds);
    }
}

