/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.Brand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="t_pcs_brand")
public class BrandDao
extends BaseDao<Brand> {
    @Autowired
    public BrandDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<Integer> getProductIdByIds(List<String> ids) {
        return super.selectList("getProductIdByIds", ids);
    }

    public List<Map> getBrandInfoByIds(Collection<String> ids) {
        return super.selectList("getBrandInfoByIds", ids);
    }

    public List<Map> getBrandInfoBySkuCodes(List<String> skuCodes) {
        return super.selectList("getBrandInfoBySkuCodes", skuCodes);
    }

    public Map<Integer, Map> getBrandInfoAll() {
        List lstMap = super.selectList("getBrandInfoAll");
        HashMap<Integer, Map> map = new HashMap<Integer, Map>();
        for (int i = 0; i < lstMap.size(); ++i) {
            Map mapItem = (Map)lstMap.get(i);
            Object brandId = mapItem.get("brandId");
            if (brandId == null) continue;
            Integer brandIdInt = Integer.parseInt(brandId.toString());
            map.put(brandIdInt, mapItem);
        }
        return map;
    }

    public Map getBrandInfoById(Integer id) {
        return (Map)super.selectOne("getBrandInfoById", (Object)id);
    }

    public List<Map> getBrandInfoByProductId(Integer productId) {
        return super.selectList("getBrandInfoByProductId", (Object)productId);
    }
}

