package com.thebeastshop.scm.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.SkuCategory;

@DaoConfig(table = "t_pcs_sku_category")
public class SkuCategoryDao extends BaseDao<SkuCategory>{
	
	@Autowired
	public SkuCategoryDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查找SKuEsVo的分类部分数据
	 */
	public List<Map> getSkuCodeAndCategoryNameByCategroyIds(List<String> ids) {
		return super.selectList("getSkuCodeAndCategoryNameByCategroyIds", new ArrayList(ids));
	}

	public List<Map> getCategoryIdAndCodedAll() {
		return super.selectList("getCategoryIdAndCodedAll");
	}

	public List<String> byParentIds(List<String> parentIds){
		List<SkuCategory> list = super.selectList(new WhereBuilder().in("parent_id", parentIds));
		List<String> ids = new ArrayList<>();
		if(CollectionUtils.isEmpty(list)){
			return ids;
		}
		for(SkuCategory skuCategory : list){
			ids.add(skuCategory.getId().toString());
		}
		return ids;
	}

	/**
	 * 得到前端类目id按(skuCode的查出的后端类目)
	 */
	public List<Map> getBackCategoryIdsByBackSkuCodes(List<String> skuCodes){
		return super.selectList("getBackCategoryIdsByBackSkuCodes", skuCodes);
	}
}