package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Product.*;

import java.math.BigDecimal;
import java.util.*;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.PsCommissionVO;
import com.thebeastshop.scm.es.PsSubsidyVO;
import com.thebeastshop.scm.po.BeastCourse;
import com.thebeastshop.scm.po.Campaign;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.po.Product;

@DaoConfig(table = "t_op_product")
public class ProductDao extends BaseDao<Product>{
	
	@Autowired
	public ProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public Product byCode(String code){
		return super.selectOne(new WhereBuilder(F_CODE, code));
	}

	public List<Product> byProductIds(List<Integer> productIds){
		return super.selectList(new WhereBuilder().in(F_ID, productIds));
	}

	public List<String> getSkuCodesById(Integer id) {
		return super.selectList("getSkuCodeById", id);
	}

	public List<Map> getProductIdSkuCodes(List<Integer> productIds) {
		return super.selectList("getProductIdSkuCodes", productIds);
	}

	public List<String> getBarCodesBySkuCodes(List<String> skuCodes) {
		return super.selectList("getBarCodesBySkuCodes", skuCodes);
	}

	public List<String> getBuBySkuCodes(List<String> skuCodes) {
		return super.selectList("getBuBySkuCodes", skuCodes);
	}

	public Integer getBeastCourseBySkuCodes(List<String> skuCodes) {
		return super.selectOne("getBeastCourseBySkuCodes", skuCodes);
	}

	public BeastCourse getBeastCourseSessionBySkuCodes(List<String> skuCodes) {
		return super.selectOne("getBeastCourseSessionBySkuCodes", skuCodes);
	}

	public List<Map> getSkuCodeBarCodes() {
		return super.selectList("getSkuCodeBarCodes");
	}

	public List<Map> getSkuCodeBu() {
		return super.selectList("getSkuCodeBu");
	}

	public List<Integer> getAllBeastCourse() {
		return super.selectList("getAllBeastCourse");
	}


	public List<PsProductVO> getPsProductVOByIds(List<Integer> ids){
		return super.selectList("getPsProductVOByIds", ids);
	}

	public PsProductVO getPsProductVOById(Integer id){
		return super.selectOne("getPsProductVOByIds", Lists.newArrayList(id));
	}


	public List<Integer> getAllProductId(){
		return super.selectFieldList("id", new WhereBuilder().gte("id", 0).orderDesc("id"));
	}
	
	/**
	 * 查找所有新官网的上架的商品productId和skucode
	 * @return
	 */
	public List<Map> getAllProductIdAndSkuCodeByOnShelf(){
		return super.selectList("getAllIdAndSkuCodeByOnShelf");
	}

	/**
	 * 根据Product ID查询后端类目ID
	 * @param productId
	 * @return
     */
	public Long getCategoryIdByProductId(Long productId) {
		return super.selectOne("getCategoryIdByProductId", productId);
	}
	
	/**
	 * 定时自动下架EMAIl内容
	 * @return
	 */
	public List<Map> mailContentByIds(List<Integer> productIds){
		return super.selectList("mailContentByIds", productIds);
	}
	
	/**
	 * PROD维护页面
	 */
	public List<Map> listProdMat(Map params){
		Integer page = MapUtils.getInteger(params, "page", 1);
		Integer size = MapUtils.getInteger(params, "size" , 20);
		if (page > 0) {
			page -- ;
		}
		int start = page * size;
		params.put("start", start);
		return super.selectList("listProdMat", params);
	}
	
	/**
	 * 是否来单制作
	 * @return ture:来单制作 false:不是来单制作
	 */
	public boolean isJitById(Integer productId){
		Integer result = super.selectOne("isJitById", productId);
		return result != null;
	}

	/**
	 * 是否来单制作
	 * @return ture:来单制作 false:不是来单制作
	 */
	public List<String> isJitByIds(List<Integer> productIds){
		List<Map> result = super.selectList("isJitByIds", productIds);
		List list = new ArrayList();
		for(Map map : result){
			list.add(map.get("code"));
		}
		return list;
	}

	/**
	 * 是否定制
	 * @return ture:定制 false:非定制
	 */
	public boolean isCustomizeById(Integer productId){
		Integer result = super.selectOne("isCustomizeById", productId);
		return result != null;
	}

	/**
	 * @return 商品ID
	 */
	public List<Integer> getJitCustomizeProductId(){
		List<Integer> result = super.selectList("getJitCustomizeProductId");
		return result;
	}

	/**
	 * @return 折扣商品ID
	 */
	public List<Integer> getDiscountProductId(){
		List<Integer> result = super.selectList("getDiscountProductId");
		return result;
	}

	public Boolean findByDiscountProductId(Integer productId){
		Integer result = super.selectOne("findByDiscountProductId", productId);
		return result != null;
	}

	public List<Map> getAllDetailBigImg() {
		return super.selectList("getAllDetailBigImg");
	}

	public Map getDetailBigImgByProdId(Integer productId) {
		return super.selectOne("getDetailBigImgByProdId", productId);
	}

	/**
	 * 查找活动页面排序
	 */
	public List<Map> getActivityPageByProdId(Integer productId) {
		if (productId == null) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getActivityPageByProdId", productId);
	}

	public Map<Integer,List<Map>> getActivityPages() {
		List<Map>  lstTotal =  super.selectList("getActivityPages");
		Map<Integer,List<Map>> productIdMap = new HashMap<Integer,List<Map>>();
		for(Map mapItem : lstTotal){
			Object objProductId = mapItem.get("productId");
			if (objProductId == null){
				continue;
			}
			Integer productId = Integer.valueOf(objProductId.toString());
			List<Map> lstMap = productIdMap.get(productId);
			if (lstMap == null){
				lstMap = new ArrayList<Map>();
				productIdMap.put(productId,lstMap);
			}
			mapItem.remove("productId");
			lstMap.add(mapItem);
		}
		return productIdMap;
	}
	
	/**
	 * 自动推荐联想输入框
	 */
	public List<Map> autoRecommendAutocomplete(String value){
		return super.selectList("autoRecommendAutocomplete", value);
	}
	
	public Map recommendAutoByProdCode(String prodCode){
		return super.selectOne("recommendAutoByProdCode", prodCode);
	}

	public Integer deleteOpClPsProdRepeatRecords(){
		return super.delete("deleteOpClPsProdRepeatRecords");
	}

	public Integer updateBrandIdByPrimaryKey(Long id ,Integer brandId){
		return super.update(new UpdateBuilder().updateEq("BRAND_ID", brandId).whereEq(F_ID, id));
	}

	public Integer updateBuByPrimaryKey(Long id ,String bu){
		return super.update(new UpdateBuilder().updateEq("bu", bu).whereEq(F_ID, id));
	}

	/**
	 * 查找佣金属性
	 */
	public List<PsCommissionVO> getCommissionByProdId(Long prodId) {
		if (prodId == null) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getCommissionByProdId", prodId);
	}

	public Map<Integer,List<PsCommissionVO>> getAllCommission() {
		List<PsCommissionVO>  lstTotal =  super.selectList("getAllCommission");
		Map<Integer,List<PsCommissionVO>> productIdMap = new HashMap<Integer,List<PsCommissionVO>>();
		if(CollectionUtils.isNotEmpty(lstTotal)) {
			for (PsCommissionVO psCommissionVO : lstTotal) {
				Long objProductId = psCommissionVO.getProductId();
				if (objProductId == null) {
					continue;
				}
				Integer productId = Integer.valueOf(objProductId.toString());
				List<PsCommissionVO> lstMap = productIdMap.get(productId);
				if (lstMap == null) {
					lstMap = new ArrayList<PsCommissionVO>();
					productIdMap.put(productId, lstMap);
				}
				lstTotal.remove("productId");
				lstMap.add(psCommissionVO);
			}
		}
		return productIdMap;
	}

	/**
	 * 查找津贴属性
	 */
	public BigDecimal getSubsidyByProdId(Long prodId) {
		if (prodId == null) {
			return null;
		}
		return super.selectOne("getSubsidyByProdId", prodId);
	}

	public Map<Integer,BigDecimal> getAllSubsidy() {
		List<PsSubsidyVO>  lstTotal =  super.selectList("getAllSubsidy");
		Map<Integer,BigDecimal> productIdMap = new HashMap<Integer,BigDecimal>();
		if(CollectionUtils.isNotEmpty(lstTotal)) {
			for (PsSubsidyVO psSubsidyVO : lstTotal) {
				Long objProductId = psSubsidyVO.getProductId();
				if (objProductId == null) {
					continue;
				}
				Integer productId = Integer.valueOf(objProductId.toString());
				productIdMap.put(productId, psSubsidyVO.getSubsidyRate());
			}
		}
		return productIdMap;
	}

}