package com.thebeastshop.scm.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.WhInvRcd;

@DaoConfig(table = "t_wh_inv_rcd")
public class InvRcdDao extends BaseDao<WhInvRcd>{
	
	@Autowired
	public InvRcdDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public int getInvRcdQuantityBySkuCodeAndWareHouseCode(List<String> skuCodes, String wareHouseCode){
		Map parameter = new HashMap();
		parameter.put("wareHouseCode", wareHouseCode);
		parameter.put("skuCodes", skuCodes);
		return super.selectOne("getInvRcdQuantityBySkuCodeAndWareHouseCode", parameter);
	}
	
}