package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ChnCanSaleProd.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ChnCanSaleProd;
import com.thebeastshop.scm.po.ProductUpDownRecord;

@DaoConfig(table = "t_op_chn_can_sale_prod")
public class ChnCanSaleProdDao extends BaseDao<ChnCanSaleProd>{
	
	@Autowired
	public ChnCanSaleProdDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public List<ChnCanSaleProd> getChannelCodeByProductIdAndChannelCode(Integer productId,String channelCode){
		return super.selectList(new WhereBuilder(F_PRODUCT_ID, productId).eq(F_CHANNEL_CODE,channelCode));
	}

	public List<ChnCanSaleProd> getChannelCodeByProductId(Integer productId){
		return super.selectList(new WhereBuilder(F_PRODUCT_ID, productId));
	}

	public ChnCanSaleProd getById(Integer id){
		return super.selectOne(new WhereBuilder(F_ID, id));
	}
	
	public ChnCanSaleProd byProductIdAndSkuCode(Integer productId, String skuCode){
		WhereBuilder wb = new WhereBuilder(F_PRODUCT_ID, productId).eq(F_ON_SHELF, 1).eq(F_CHANNEL_CODE, "CHN2018").like(F_CAN_SALE_SKU, skuCode).like(F_CAN_SEE_SKU, skuCode);
		return super.selectOne(wb);
	}
	
	public ChnCanSaleProd byChannelCodeAndProductId(String channelCode, Integer productId){
		return super.selectOne(new WhereBuilder(F_CHANNEL_CODE, channelCode).eq(F_PRODUCT_ID, productId));
	}
	
	/**
	 * 修改状态为下架按proudctId
	 */
	public void downByProductId(Integer productId) {
		super.update(new UpdateBuilder().updateEq(F_ON_SHELF, 0).whereEq(F_PRODUCT_ID, productId));
	}
	
	/**
	 * 修改状态按ID
	 */
	public void updateOnshelfById(Integer id, ChnCanSaleProd.OnShelf onshelf) {
		super.update(new UpdateBuilder().updateEq(F_ON_SHELF, onshelf.value).whereEq(F_ID, id));
	}

	public void updateOnshelfAndCreateTimeById(Integer id, ChnCanSaleProd.OnShelf onshelf,Date time) {
		super.update(new UpdateBuilder().updateEq(F_ON_SHELF, onshelf.value).updateEq(F_CREATE_TIME,time).whereEq(F_ID, id));
	}
	
	/**
	 * 上下架列表页面
	 */
	public List<Map> listProdUpDown(Map params){
		Integer page = MapUtils.getInteger(params, "page", 1);
		Integer size = MapUtils.getInteger(params, "size" , 20);
		if (page > 0) {
			page -- ;

		}
		int start = page * size;
		params.put("start", start);
		return super.selectList("listProdUpDown", params);
	}
	
	/**
	 * 上下架审批列表页面
	 */
	public List<Map> listProdUpDownApproval(Map params){
		Integer page = MapUtils.getInteger(params, "page", 1);
		Integer size = MapUtils.getInteger(params, "size" , 20);
		if (page > 0) {
			page -- ;
		}
		int start = page * size;
		params.put("start", start);
		return super.selectList("listProdUpDownApproval", params);
	}
}