package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Channel.*;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Channel;

@DaoConfig(table = "t_op_channel")
public class ChannelDao extends BaseDao<Channel>{
	
	
	@Autowired
	public ChannelDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 得到野兽派新官网
	 */
	public Channel byNewWebsites(){
		String NEW_WEBSITES = "CHN2018";
		return super.selectOne(new WhereBuilder(F_CODE, NEW_WEBSITES));
	}

	/**
	 * 得到野兽派APP
     */
	public Channel byApp() {
		String APP = "CHN2049";
		return super.selectOne(new WhereBuilder(F_CODE, APP));
	}
	
	public List<Channel> findAll(){
		return super.selectList(new WhereBuilder().gt(F_ID, 0));
	}
	
	public Channel byCode(String code){
		return super.selectOne(new WhereBuilder(F_CODE, code));
	}

	public List<Channel> byCodes(List<String> codes){
		return super.selectList("getChannelByCodes", codes);
	}


	public List<Channel> getChannelByType(Integer type){
		return super.selectList("getChannelByType", type);
	}

}