package com.thebeastshop.scm.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Label;

@DaoConfig(table = "label")
public class LabelDao extends BaseDao<Label>{
	
	@Autowired
	public LabelDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查找es中的需要的数据按productId
	 */
	public List<Map> getEsLabelByProductId(Integer productId) {
		return super.selectList("getEsLabelByProductId", productId);
	}

	public Map<Integer,List<Map>> getEsLabelByProductIdAll() {
		List<Map>  lstTotal =  super.selectList("getEsLabelByProductIdAll");
		Map<Integer,List<Map>> productIdMap = new HashMap<Integer,List<Map>>();
		for(Map mapItem : lstTotal){
			Object objProductId = mapItem.get("productId");
			if (objProductId == null){
				continue;
			}
			Integer productId = Integer.valueOf(objProductId.toString());
			List<Map> lstMap = productIdMap.get(productId);
			if (lstMap == null){
				lstMap = new ArrayList<Map>();
				productIdMap.put(productId,lstMap);
			}
			mapItem.remove("productId");
			lstMap.add(mapItem);
		}
		return productIdMap;
	}


	/**
	 * 查找es中的海淘标签按productId
	 */
	public List<Map> getCrossBoederEsLabelByProductId(Integer productId) {
		return super.selectList("getCrossBoederEsLabelByProductId", productId);
	}

	public List<Map> getCrossBoederEsLabelByAll() {
		return super.selectList("getCrossBoederEsLabelByAll");
	}


	/**
	 * 查找es中的活动标签按productId
	 */
	public List<Map> getCampaignEsLabelByProductId(Integer productId) {
		return super.selectList("getCampaignEsLabelByProductId", productId);
	}

	public List<Map> getCampaignEsLabelByAll() {
		return super.selectList("getCampaignEsLabelByAll");
	}

	public List<Map> getCampaignEsLabelByGlobal() {
		return super.selectList("getCampaignEsLabelByGlobal");
	}


	public List<Map> getCampaignEsLabelByAllData() {
		return super.selectList("getCampaignEsLabelByAllData");
	}

	/**
	 *
	   活动商品id维度
	 */
	public List<Map> getCampaignEsLabelByProdcutId() {
		return super.selectList("getCampaignEsLabelByProdcutId");
	}


	/**
	 * 活动skucode维度，返回的是商品map
	 * @return
	 */
	public List<Map> getCampaignEsLabelBySkuCode() {
		return super.selectList("getCampaignEsLabelBySkuCode");
	}

	/**
	 * 查找es中的品牌标签按productId
	 */
	public List<Map> getBrandEsLabelByProductId(Integer productId) {
		return super.selectList("getBrandEsLabelByProductId", productId);
	}

	public List<Map> getBrandEsLabelByAll() {
		return super.selectList("getBrandEsLabelByAll");
	}



	public List<Map> getCategoryEsLabelByProductId(Integer productId) {
		return super.selectList("getCategoryEsLabelByProductId", productId);
	}

	public List<Map> getCategoryEsLabelByAll() {
		return super.selectList("getCategoryEsLabelByAll");
	}

}