package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.SkuCategoryFront.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.SkuCategoryFront;

@DaoConfig(table = "t_pcs_sku_category_front")
public class SkuCategoryFrontDao extends BaseDao<SkuCategoryFront>{
	
	@Autowired
	public SkuCategoryFrontDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	public List<SkuCategoryFront> getSkuCategoryFrontAll(){
		return super.selectList("getSkuCategoryFrontAll");
	}
	
	/**
	 * 查所有类目主要类目和次级类目
	 */
	public List<Map> getProductEsFrontCategoriesBySkuCodes(List<String> skuCodes) {
		return super.selectList("getProductEsFrontCategoriesBySkuCodes", skuCodes);
	}
	
	
	public List<Map> getSkuEsVoFrontCategoriesBySkuCodes(String skuCode) {
		return super.selectList("getPcsSkuCategoryVOBySkuCodes", skuCode);
	}
	
	public List<Integer> getProductIdByIds(List<String> ids) {
		return super.selectList("getProductIdByIds", ids);
	}
	
	/**
	 * 得到前端类目id按(skuCode的查出的后端类目)
	 */
	public List<Map> getFrontCategoryIdsByBackSkuCode(List<String> skuCodes){
		return super.selectList("getFrontCategoryBySkuCode", skuCodes);
	}
	
	/**
	 * 查询所有前端类目ID按code
	 * @return
	 */
	public List<Integer> getIdsByCode(String code){
		SkuCategoryFront skuCategoryFront = super.selectOne(new WhereBuilder(F_CODE, code));
		if (skuCategoryFront == null) {
			return Collections.EMPTY_LIST;
		}
		List<Integer> result = new ArrayList<Integer>();
		if (skuCategoryFront.getParentId() == null) {//判断是一级类目查找所有类目ID
			List<Integer> categroy2 = super.selectFieldList(F_ID, new WhereBuilder(F_PARENT_ID, skuCategoryFront.getId()));
			result.addAll(categroy2);
		}
		result.add(skuCategoryFront.getId());
		return result;
	}
	//根据ID查询类目
	public List<Map> getSkuEsVoFrontCategoriesByIds(List<String> ids) {
		return super.selectList("getSkuEsVoFrontCategoriesByIds", ids);
	}
}