package com.thebeastshop.scm.dao;

import com.google.common.collect.Lists;
import com.thebeastshop.scm.es.PsCampaignSectionVO;
import com.thebeastshop.scm.po.CampaignSection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-17
 */
@DaoConfig(table = "campaign_section")
public class CampaignSectionDao extends BaseDao<CampaignSection> {

    @Autowired
    public CampaignSectionDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }


    /**
     * 通过活动编号获取活动所关联的优惠区间
     * @param campaignId
     * @return
     */
    public List<PsCampaignSectionVO> findCampaignSectionByCampaignId(Long campaignId) {
        List<PsCampaignSectionVO> voList = new ArrayList<>();
        List<CampaignSection> list = super.selectList(
                new WhereBuilder("campaign_id", campaignId).eq("temp", 0));
        if(CollectionUtils.isNotEmpty(list)) {
            for (CampaignSection campaignSection : list) {
                PsCampaignSectionVO vo = new PsCampaignSectionVO(campaignSection);

                voList.add(vo);
            }
        }
        return voList;
    }


    /**
     * 通过活动编号以及skuCode获取SKU维度活动所关联的优惠区间
     * @param campaignId
     * @param skuCode
     * @return
     */
    public List<PsCampaignSectionVO> findCampaignSectionBySkuCode(Long campaignId, String skuCode) {
        List<PsCampaignSectionVO> result = Lists.newArrayList();
        Map<String, Object> params = new HashedMap();
        params.put("campaignId", campaignId);
        params.put("skuCode", skuCode);
        List<CampaignSection> list = super.selectList("findCampaignSectionBySkuCode", params);
        if(CollectionUtils.isNotEmpty(list)) {
            PsCampaignSectionVO vo;
            for (CampaignSection campaignSection : list) {
                vo = new PsCampaignSectionVO(campaignSection);
                result.add(vo);
            }
        }
        return result;
    }
}
