/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.InterestGoodsSku;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="interest_goods_sku")
public class InterestGoodsSkuDao
extends BaseDao<InterestGoodsSku> {
    @Autowired
    public InterestGoodsSkuDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<InterestGoodsSku> byInterestGoodsId(Integer interestGoodsId) {
        return super.selectList(new WhereBuilder("interest_goods_id", (Object)interestGoodsId).orderAsc("id"));
    }

    public InterestGoodsSku getInterestGoodsSku(Integer interestGoodsId, String skuCode) {
        return (InterestGoodsSku)super.selectOne(new WhereBuilder().eq("interest_goods_id", (Object)interestGoodsId).eq("sku_code", (Object)skuCode));
    }

    public InterestGoodsSku getInStockByInterestGoodsId(Integer interestGoodsId) {
        return (InterestGoodsSku)super.selectOne("getInStockByInterestId", (Object)interestGoodsId);
    }

    public Integer sumQuantityByInterestId(Integer interestGoodsId) {
        return (Integer)super.selectOne("sumQuantityByInterestId", (Object)interestGoodsId);
    }

    public int deleteByInterestGoodsId(int interestGoodsId) {
        return super.delete(new WhereBuilder("interest_goods_id", (Object)interestGoodsId));
    }

    public boolean addReceiveQuantity(Integer id) {
        return super.update("addReceiveQuantity", (Object)id) == 1;
    }

    public boolean reduceReceiveQuantity(Integer id) {
        return super.update("reduceReceiveQuantity", (Object)id) == 1;
    }

    public boolean updateCash(List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        int result = 0;
        for (InterestGoodsSkuVO interestGoodsSkuVo : interestGoodsSkuVOList) {
            result += super.update("updateCashQuantity", (Object)interestGoodsSkuVo.toMap());
        }
        return result == interestGoodsSkuVOList.size();
    }

    public boolean reduceCashQuantity(List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        int result = 0;
        for (InterestGoodsSkuVO interestGoodsSkuVo : interestGoodsSkuVOList) {
            result += super.update("reduceCashQuantity", (Object)interestGoodsSkuVo.toMap());
        }
        return result == interestGoodsSkuVOList.size();
    }
}

