package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.SoPackage;
import com.thebeastshop.scm.po.SoPackageCard;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;

@DaoConfig(table = "t_op_so_package_card")
public class SoPackageCardDao extends BaseDao<SoPackageCard>{

	@Autowired
	public SoPackageCardDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 根据包裹号查询包裹卡片信息
	 * @param packageId
	 * @return
	 */
	public List<SoPackageCard> findSoPackageCardByPackageId(Integer packageId){
		WhereBuilder whereBuilder = new WhereBuilder();
		whereBuilder.eq("PACKAGE_ID", packageId);
		return super.selectList(whereBuilder);
	}
}