package com.thebeastshop.scm.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.po.Attribute;

@DaoConfig(table = "t_op_attribute")
public class AttributeDao extends ScmBaseDao<Attribute>{
	
	@Autowired
	public AttributeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public List<PsAttributeVO> getEsByProductId(Long productId) {
		List<Map> list = super.selectList("getEsByProductId", productId);
		list = convergeMapList(list, primaryKeyName);
		List<PsAttributeVO> result =  new ArrayList<>();
		for (Map attributeMap : list) {
			PsAttributeVO attributeVo = new PsAttributeVO(attributeMap);
			result.add(attributeVo);
		}
		return result;
	}

	public Map<Integer,List<PsAttributeVO>>getEsByProductIdAll() {
		Map<Integer,List<PsAttributeVO>> mapResult = new HashMap<Integer,List<PsAttributeVO>>();

		List<Map> listAll = super.selectList("getEsByProductIdAll");
		Map<Integer,List<Map>> productIdMap = new HashMap<Integer,List<Map>>();
		for(Map mapItem : listAll){
			if (mapItem.get("productId") == null){
				continue;
			}
			Integer productId = Integer.valueOf(mapItem.get("productId").toString());
			List<Map>  lstTemp = productIdMap.get(productId);
			if (lstTemp == null){
				lstTemp = new ArrayList<Map>();
				productIdMap.put(productId,lstTemp);
			}
			lstTemp.add(mapItem);
		}

		for(Map.Entry<Integer,List<Map>> mapItem : productIdMap.entrySet()){
			List<Map>  list = mapItem.getValue();
			list = convergeMapList(list, primaryKeyName);
			List<PsAttributeVO> listResult =  new ArrayList<>();
			for (Map attributeMap : list) {
				PsAttributeVO attributeVo = new PsAttributeVO(attributeMap);
				listResult.add(attributeVo);
			}
			mapResult.put(mapItem.getKey(),listResult);
		}
        return mapResult;
	}


	public List<PsAttributeValuePairVO> findPairByIds(List<Long> ids) {
		Map params = new HashMap();
		params.put("ids", ids);
		List<Map> list = super.selectList("findPairByIds", params);
		list = convergeMapList(list, primaryKeyName);
		List<PsAttributeValuePairVO> result =  new ArrayList<>();
		for (Map attributePairMap : list) {
			PsAttributeValuePairVO attributeValuePairVo = new PsAttributeValuePairVO(attributePairMap);
			String attrName1 = attributeValuePairVo.getAttrName1();
			String attrValue1 = attributeValuePairVo.getAttrValue1();
			if(StringUtils.isBlank(attrName1) || StringUtils.isBlank(attrValue1)){
				continue;
			}else{
				PsAttributeValuePairVO attributeValuePairVo1 = new PsAttributeValuePairVO(attributePairMap);
				attributeValuePairVo1.setAttrName(attrName1);
				attributeValuePairVo1.setValue(attrValue1);
				attributeValuePairVo1.setAttrName1(null);
				attributeValuePairVo1.setAttrName2(null);
				attributeValuePairVo1.setAttrName3(null);
				attributeValuePairVo1.setAttrValue1(null);
				attributeValuePairVo1.setAttrValue2(null);
				attributeValuePairVo1.setAttrValue3(null);
				result.add(attributeValuePairVo1);
			}

			String attrName2 = attributeValuePairVo.getAttrName2();
			String attrValue2 = attributeValuePairVo.getAttrValue2();
			if(StringUtils.isBlank(attrName2) || StringUtils.isBlank(attrValue2)){
				continue;
			}else{
				PsAttributeValuePairVO attributeValuePairVo2 = new PsAttributeValuePairVO(attributePairMap);
				attributeValuePairVo2.setAttrName(attrName2);
				attributeValuePairVo2.setValue(attrValue2);
				attributeValuePairVo2.setAttrName1(null);
				attributeValuePairVo2.setAttrName2(null);
				attributeValuePairVo2.setAttrName3(null);
				attributeValuePairVo2.setAttrValue1(null);
				attributeValuePairVo2.setAttrValue2(null);
				attributeValuePairVo2.setAttrValue3(null);
				result.add(attributeValuePairVo2);
			}
			String attrName3 = attributeValuePairVo.getAttrName3();
			String attrValue3 = attributeValuePairVo.getAttrValue3();
			if(StringUtils.isBlank(attrName3) || StringUtils.isBlank(attrValue3)){
				continue;
			}else{
				PsAttributeValuePairVO attributeValuePairVo3 = new PsAttributeValuePairVO(attributePairMap);
				attributeValuePairVo3.setAttrName(attrName3);
				attributeValuePairVo3.setValue(attrValue3);
				attributeValuePairVo3.setAttrName1(null);
				attributeValuePairVo3.setAttrName2(null);
				attributeValuePairVo3.setAttrName3(null);
				attributeValuePairVo3.setAttrValue1(null);
				attributeValuePairVo3.setAttrValue2(null);
				attributeValuePairVo3.setAttrValue3(null);
				result.add(attributeValuePairVo3);
			}
		}
		return result;

	}


}

