package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ClPsProd.*;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ClPsProd;

@DaoConfig(table = "t_op_cl_ps_prod")
public class ClPsProdDao extends BaseDao<ClPsProd>{
	
	@Autowired
	public ClPsProdDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public List<ClPsProd> limit(int limitSize) {
		return super.selectList(new WhereBuilder().orderAsc(F_ID).limit(limitSize));
	}

	/**
	 * 删除小于或者等于maxId的记录
	 * @param maxId
	 * @return
	 */
	public int deleteMaxId(Integer maxId) {
		return super.delete(new WhereBuilder().lte(F_ID, maxId));		
	}
	
}