package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.po.Campaign;
import com.thebeastshop.scm.po.CampaignExcludeProduct;
import com.thebeastshop.scm.po.CampaignProduct;
import com.thebeastshop.scm.po.CategoryCampaign;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * Desc:活动关联商品相关的dao接口
 * Created by hafiz.zhang on 2016/12/30.
 */
@DaoConfig(table = "campaign_product")
public class CampaignProductDao extends BaseDao<CampaignProduct> {

    @Autowired
    public CampaignProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    /**
     * 查找SKU对应的抢购信息
     */
    public CampaignProduct findCampaignProductBySkuCode(String skuCode, Long campaignId) {
        Map<String, Object> params = new HashedMap();
        params.put("skuCode", skuCode);
        params.put("campaignId", campaignId);
//        CampaignProduct campaignProduct = super.selectOne("getLimitAmountBySkuCode", params);
        List<CampaignProduct> campaignProductList = super.selectList("getLimitAmountBySkuCode", params);
        if(CollectionUtils.isNotEmpty(campaignProductList)){
            return campaignProductList.get(0);
        }
        return null;
    }

    /*
      根据活动ids查询出相关的类别ids
     */
    public List<Long> getCategoryByCampaigns(List<Long> campaignIds){
        return super.selectList("getCategoryByCampaigns", campaignIds);
    }

    /*
    获取所有活动类别的ids
     */
    public List<Long> getCategoryByAllCampaign(){
        return super.selectList("getCategoryByAllCampaign");
    }

    /*
    获取所有活动类别的ids
     */
    public List<Long> getCategoryByAllProgressCampaign(){
        return super.selectList("getCategoryByAllProgressCampaign");
    }

    /*
      根据类别ids获取相关的类别和活动的对应关系
     */
    public List<CategoryCampaign> getCategoryAndCampaigns(List<Long> categoryIds){
        return super.selectList("getCategoryAndCampaigns", categoryIds);
    }

    /*
      根据活动id获取排除商品的id和skuCode
     */
    public List<CampaignExcludeProduct> getCampaignExcludeProduct(List<Long> campaignIds){
        return super.selectList("getCampaignExcludeProduct", campaignIds);
    }
}
