package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Sku.*;

import java.util.*;

import com.thebeastshop.scm.es.PsSkuAttributeVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsSkuVO;
import com.thebeastshop.scm.po.Sku;
import com.thebeastshop.scm.vo.EditProductSkuInfoVo;

@DaoConfig(table = "t_pcs_sku")
public class SkuDao extends BaseDao<Sku> {
	
	@Autowired
	public SkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public Sku byCode(String code){
		return super.selectOne(new WhereBuilder(F_CODE, code));
	}
	
	public Integer getCrossBorderFlagByCodes(List<String> codes){
		return super.selectOne("getCrossBorderFlagByCodes", codes);
	}

	public Integer getIsJitByCodes(List<String> codes){
		return super.selectOne("getIsJitByCodes", codes);
	}
	
	/**
	 * 查询es主要数据
	 */
	public List<PsSkuVO> getEsSkuVo(List<String> codes){
		if (CollectionUtils.isEmpty(codes)) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getEsSkuVo", codes);
	}
	
	public Date getLastSaleStartDateByCodes(List<String> skuCodes) {
		Date date = super.selectOne("getLastSaleStartDateByCodes", skuCodes);
		return date;
	}
	
	public Map getSaleStartDateAndProductIdBySkuCode(String skuCode) {
		return super.selectOne("getSaleStartDateAndProductIdBySkuCode", skuCode);
	}
	
	public Map getCategoryIdAndCategoryCodeByCodes(List<String> codes) {
		return super.selectOne("getCategoryIdAndCategoryCodeByCodes", codes);
	}
	
	public List<Integer> getProductIdBySkuCodes(List<String> codes) {
		if (CollectionUtils.isEmpty(codes)) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getProductIdBySkuCodes", codes);
	}
	
	public List<String> getAllCode(){
		return super.selectFieldList(F_CODE, new WhereBuilder().gt("id", 0));
	}
	
	public Map<String, Object> getMinSalePrice(List<String> codes){
		return super.selectOne("getMinSalePrice", codes);
	}

	public List<Map> getMinSalePriceSkuCodes(List<String> codes){
		return super.selectList("getMinSalePriceSkuCodes", codes);
	}


	public List<Integer> getProductIdsByCodes(List<String> codes){
		return super.selectList("getProductIdsByCodes", codes);
	}
	
	public List<EditProductSkuInfoVo> getEditProductSkuInfoByProdId(Integer productId) {
		return super.selectList("getEditProductSkuInfoByProdId", productId);
	}
	
	/**
	 * 查找没有被绑定过的SKU
	 */
	public List<EditProductSkuInfoVo> findNoUserdByNameOrCode(String value) {
		return super.selectList("findNoUserdByNameOrCode", value);
	}
	/**
	 * 查找没有被绑定过的SKU
	 */
	public List<Map> getCodeAndNameByProductCode(String productCode) {
		return super.selectList("getCodeAndNameByProductCode", productCode);
	}

	/**
	 * 查找SKU绑定的属性
	 */
	public List<PsSkuAttributeVO> getSkuAttributeBySkuCodes(List<String> skuCodes) {
		if (CollectionUtils.isEmpty(skuCodes)) {
			return Collections.EMPTY_LIST;
		}
		return super.selectList("getSkuAttributeBySkuCodes", skuCodes);
	}

	/**
	 * 查找月送属性
	 */
	public Integer getFlowerMonthlyBySkuCode(String skuCode) {
		return super.selectOne("getFlowerMonthlyBySkuCode", skuCode);
	}


	public Set<String> getSkuSample(){
		List<String> list =  super.selectList("getSkuSample");
		Set<String> sets = new HashSet<String>();
		for(String str : list){
			sets.add(str);
		}
		return sets;
	}
}