package com.thebeastshop.scm.dao;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.UserSign;

@DaoConfig(table = "t_op_user_sign")
public class UserSignDao extends BaseDao<UserSign>{
	
	@Autowired
	public UserSignDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 根据memberCode查询用户标签信息集合
	 * @param memberCode
	 * @return
	 */
	public List<UserSign> queryUserSignListByMemberCode(String memberCode){
		WhereBuilder builder = new WhereBuilder("MEMBER_CODE", memberCode);
		return super.selectList(builder);
	}
	
	/**
	 * 新增用户标签
	 * @param userSign
	 * @return
	 */
	public Integer addUserSign(UserSign userSign){
		return super.insert(userSign);
	}
}