package com.thebeastshop.scm.dao;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SoPackageSku;
import com.thebeastshop.scm.vo.SoPackageSkuVO;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_so_package_sku")
public class SoPackageSkuDao extends BaseDao<SoPackageSku>{
	
	@Autowired
	public SoPackageSkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	/**
	 * 根据packageId查询商品集合
	 * @param packageId
	 * @return
	 */
	public List<SoPackageSkuVO> findSoPackageSkuByPackageId(Integer packageId){
		return super.selectList("findSoPackageSkuByPackageId", packageId);
	}
	
	/**
	 * 根据packageIds集合查询商品集合
	 * @param packageIds
	 * @return
	 */
	public List<SoPackageSkuVO> findSoPackageSkuByPackageIds(List<Integer> packageIds){
		return super.selectList("findSoPackageSkuByPackageIds", packageIds);
	}
	
	/**
	 *  得到预售商品已卖出的数量
	 */
	public Integer getQuantityBySkuCode(List<String> skuCodes){
		return super.selectOne("getQuantityBySkuCode", skuCodes);
	}
	
	
}