package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ProductAutoDownFlag.*;

import java.util.Date;

import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ProductAutoDownFlag;

@DaoConfig(table = "t_op_product_auto_down_flag")
public class ProductAutoDownFlagDao extends BaseDao<ProductAutoDownFlag>{
	
	@Autowired
	public ProductAutoDownFlagDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 删除两天之前的数据
	 */
	public void deleteTwoDay(){
		 super.delete(new WhereBuilder().lt(F_CREATE_TIME, new DateTime().minusDays(2).toDate()));
	}

	/**
	 * 删除X天之前的数据
	 */
	public void deleteXDay(int days){
		super.delete(new WhereBuilder().lt(F_CREATE_TIME, new DateTime().minusDays(days).toDate()));
	}
	
	public void save(Integer productId, Date createTime){
		ProductAutoDownFlag productAutoDownFlag = new ProductAutoDownFlag();
		productAutoDownFlag.setProductId(productId);
		productAutoDownFlag.setCreateTime(createTime);
		super.insert(productAutoDownFlag);
	}
	
	public int deleteByProductId(Integer productId){
		return super.delete(new WhereBuilder(F_PRODUCT_ID, productId));
	}
	
	
}