package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.ProdSku.*;
import static com.thebeastshop.scm.po.Sku.F_CODE;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsSpvVO;
import com.thebeastshop.scm.po.ProdSku;

@DaoConfig(table = "t_op_prod_sku")
public class ProdSkuDao extends BaseDao<ProdSku> {

	
	@Autowired
	public ProdSkuDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public void save(Integer productId, String skuCode, Integer minAmount){
		ProdSku prodSku = new ProdSku();
		prodSku.setProductId(productId);
		prodSku.setSkuCode(skuCode);
		prodSku.setMinAmount(minAmount);
		super.insertOrUpdate(prodSku, new WhereBuilder(F_PRODUCT_ID, productId).eq(F_SKU_CODE, skuCode));
	}

	public List<Integer> getAllIds() {
		return super.selectFieldList("id", new WhereBuilder().gt("id", 0));
	}

	public List<PsSpvVO> getEsSpvVOs(List<Integer> spvIds) {
//		List<ProdSku> prodSkuList = super.selectList(new WhereBuilder(F_PRODUCT_ID, productId).eq(F_ACTIVE, 1));
		Map<String, Object> params = new HashMap<>();
		params.put("ids", spvIds);
		List<ProdSku> prodSkuList = super.selectList("getSpvByIds", params);
		List<PsSpvVO> result = new ArrayList<PsSpvVO>();
		for (ProdSku prodSku : prodSkuList) {
			PsSpvVO spvVO = new PsSpvVO(prodSku);
			result.add(spvVO);
		}
		return result;
	}


	public List<PsSpvVO> getEsSpvVObyProductId(Integer productId){
//		List<ProdSku> prodSkuList = super.selectList(new WhereBuilder(F_PRODUCT_ID, productId).eq(F_ACTIVE, 1));
		List<ProdSku> prodSkuList = super.selectList("getSpvByProductId", productId);
		List<PsSpvVO> result = new ArrayList<PsSpvVO>();
		for (ProdSku prodSku : prodSkuList) {
			PsSpvVO spvVO = new PsSpvVO(prodSku);
			result.add(spvVO);
		} 
		return result;
	}


	public List<String> findSkuCodeByCombinedSpvId(Integer spvId) {
		return super.selectList("findSkuCodeByCombinedSpvId", spvId);
	}


	public Map<String, Object> getMinSalePrice(List<Integer> spvIds) {
		return super.selectOne("getMinSalePrice", spvIds);
	}

	public List<ProdSku> getNotCombindSku(Integer limitStart,Integer limitSize,Integer skuType){
		Map<String,Object> params = new HashMap<String,Object>();
		params.put("limitStart",limitStart);
		params.put("limitSize",limitSize);
		params.put("skuType",skuType);
		return  super.selectList("getNotCombindSku",params);
	}

	public List<ProdSku> getCombindSku(Integer skuType){
		Map<String,Object> params = new HashMap<String,Object>();
		params.put("skuType",skuType);
		return  super.selectList("getCombindSku",params);
	}


	public List<Map> getSkuBuyerInfo(List<String> skuCodes){
		List<Map> lstMap = super.selectList("getSkuBuyerInfo",skuCodes);
		return lstMap;
	}

}