package com.thebeastshop.scm.dao;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.CustomerService;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_customer_service")
public class CustomerServiceDao extends BaseDao<CustomerService>{
	
	@Autowired
	public CustomerServiceDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 新增客服接待信息
	 * @param userSign
	 * @return
	 */
	public Integer addCustomerService(CustomerService customerService){
		return super.insert("addCustomerService",customerService);
	}
}