package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.SearchSuggest;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;
import java.util.Map;

import static pers.richard.ormybatis.domain.po.IdPo.F_ID;

/**
 * Created by gensheng.ye on 2017/12/27.
 */
@DaoConfig(table = "search_suggest")
public class SearchSuggestDao extends BaseDao<SearchSuggest> {

    @Autowired
    public SearchSuggestDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<SearchSuggest> getList(String keywordType,String isDel){
        Map<String, Object> params = new HashedMap();
        params.put("keywordType", keywordType);
        params.put("isDel", isDel);
        return super.selectList("getList",params);
    }

    /**
     * 批量删除ID
     * @param ids
     * @return
     */
    public int deleteIds(List<Integer> ids){
        return super.delete(new WhereBuilder().in(F_ID, ids));
    }
}
