package com.thebeastshop.scm.dao;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

import java.util.*;

/**
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2016-11-01 23:05
 */
public class ScmBaseDao<T extends IdPo> extends BaseDao<T> {

    public ScmBaseDao(SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    protected List<Map> convergeMapList(List<Map> results, String primaryKey) {
        if (CollectionUtils.isEmpty(results)) {
            return results;
        }

        if (!results.get(0).containsKey(primaryKey)) {
            return results;
        }
        Map<Object, Map> newMapList = new LinkedMap();
        for (Map map : results) {
            Object id = map.get(primaryKey);
            Map newMap = newMapList.get(id);
            if (newMap == null) {
                newMap = new HashedMap();
                newMapList.put(id, newMap);
                processMap(map, newMap, true);
            }
            processMap(map, newMap, false);
        }

        List<Map> newList = new ArrayList<>();
        for (Iterator<Map.Entry<Object, Map>> iterator = newMapList.entrySet().iterator(); iterator.hasNext(); ) {
            Map.Entry<Object, Map> entry = iterator.next();
            newList.add(entry.getValue());
        }
        return newList;
    }


    private void processMap(Map map, Map newMap, boolean isNew) {
        for (Iterator<String> iterator = map.keySet().iterator(); iterator.hasNext(); ) {
            String key = iterator.next();
            Object value = map.get(key);
            if (value != null && value instanceof Map) {
                if (isNew) continue;
                List<Map> subList;
                if (!newMap.containsKey(key)) {
                    subList = new ArrayList<>();
                    newMap.put(key, subList);
                }
                else {
                    subList = (List<Map>) newMap.get(key);
                }
                subList.add((Map) value);
            }
            else {
                if (!isNew) continue;
                newMap.put(key, map.get(key));
            }
        }
    }
}
