package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsCampaignVO;
import com.thebeastshop.scm.po.Campaign;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-14 */
@DaoConfig(table = "campaign")
public class CampaignDao extends BaseDao<Campaign> {


    @Autowired
    public CampaignDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    /**
     * 根据商品编号以及商品所在的类目查找所有有效的活动
     * @param productId 商品编号
     * @param categoryId 所属类目
     * @return
     */
    public List<PsCampaignVO> matchProductCampaigns(Long productId, Long categoryId, Integer crossBorderFlag) {
        Map<String, Object> params = new HashedMap();
        params.put("productId", productId);
        params.put("categoryId", categoryId);
        params.put("crossBorderFlag", crossBorderFlag);
        List<Campaign> list = super.selectList("matchProductCampaigns", params);
        return PsCampaignVO.transfer(list);
    }

    /*
      根据商品匹配相关的活动 by gensheng.ye 2017/11/22
     */
    public List<PsCampaignVO> matchCampaignsByProductId(Long productId) {
        Map<String, Object> params = new HashedMap();
        params.put("productId", productId);
        List<Campaign> list = super.selectList("matchCampaignsByProductId", params);
        return PsCampaignVO.transfer(list);
    }



    /**
     * 查找所有的活动
     * @return
     */
    public List<PsCampaignVO> findAllCampaignList() {
        List<Campaign> list = super.selectList(new WhereBuilder());
        return PsCampaignVO.transfer(list);
    }

    /**
     * 查找所有的SKU维度的活动
     */
    public List<PsCampaignVO> findCampaignsBySkuCode(String skuCode, Integer categoryId, Integer crossBorderFlag) {
        Map<String, Object> params = new HashedMap();
        params.put("skuCode", skuCode);
        params.put("categoryId", categoryId);
        params.put("crossBorderFlag", crossBorderFlag);
        List<Campaign> skuCampaigns = super.selectList("getCampaignBySkuCode", params);
        return PsCampaignVO.transfer(skuCampaigns);
    }

    /*
     查找所有的SKU维度的活动
     by gensheng.ye 2017/11/22
     */
    public List<PsCampaignVO> findCampaignsBySkuCode2(String skuCode) {
        Map<String, Object> params = new HashedMap();
        params.put("skuCode", skuCode);
        List<Campaign> skuCampaigns = super.selectList("getCampaignBySkuCode2", params);
        return PsCampaignVO.transfer(skuCampaigns);
    }


    public List<PsCampaignVO> findCampaignListByIds(List<Integer> ids) {
        List<Campaign> list = super.selectList(new WhereBuilder().in(primaryKeyName, ids));
        return PsCampaignVO.transfer(list);
    }

    public List<PsCampaignVO> findCampaignListByCodes(List<String> codes) {
        List<Campaign> campaigns = super.selectList("findCampaignListByCodes", codes);
        return PsCampaignVO.transfer(campaigns);
    }

    /**
     * 获取指定活动编号中所有的Product维度的活动
     * @param campaignIds
     * @return
     */
    public List<PsCampaignVO> findProductCampaignsByIds(List<Long> campaignIds) {
        List<Campaign> productCampaigns = super.selectList("findProductCampaignsByIds", campaignIds);
        return PsCampaignVO.transfer(productCampaigns);
    }

    /**
     * 获取指定活动编号中所有的SKU维度的活动
     * @param campaignIds
     * @return
     */
    public List<PsCampaignVO> findSkuCampaignsByIds(List<Long> campaignIds) {
        List<Campaign> skuCampaigns = super.selectList("findSkuCampaignsByIds", campaignIds);
        return PsCampaignVO.transfer(skuCampaigns);
    }


    /**
     * 获取指定活动所关联的商品编号集合
     * @param campaignIds
     * @return
     */
    public List<Integer> getProductIdsByCampaignIds(List<Long> campaignIds) {
        return super.selectList("getProductIdsByCampaignIds", campaignIds);
    }

    /**
     * 获取指定活动所关联的类目编号集合
     * @param campaignIds
     * @return
     */
    public List<Integer> getCategoryIdsByCampaignIds(List<Long> campaignIds) {
        return super.selectList("getCategoryIdsByCampaignIds", campaignIds);
    }

    /**
     * 获取指定活动所关联的SKU编号集合
     * @param skuCampaignIds
     * @return
     */
    public List<Integer> getSpvIdsByCampaignIds(List<Long> skuCampaignIds) {
        return super.selectList("getSpvIdsByCampaignIds", skuCampaignIds);
    }


    /*
       获取当前有效的活动信息
       by gensheng.ye 2017/11/21
     */
    public List<PsCampaignVO> getEffectiveCampaigns() {
        List<Campaign> campaigns = super.selectList("getEffectiveCampaigns");
        return PsCampaignVO.transfer(campaigns);
    }

    public Integer deleteOpClPsCampaignRepeatRecords(){
        return super.delete("deleteOpClPsCampaignRepeatRecords");
    }

}
