package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Recommend.*;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.scm.po.Recommend;

@DaoConfig(table = "recommend")
public class RecommendDao extends BaseDao<Recommend> {
	
	@Autowired
	public RecommendDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 按展示位置保存记录
     */
	public void saveByPosition(Recommend recommend){
		super.insertOrUpdate(recommend, new WhereBuilder(F_POSITION, recommend.getPosition()));
	}
	
	public String getRuleByCart(){
		List<String>  result = super.selectFieldList(F_RULE, new WhereBuilder(F_POSITION, Recommend.Position.CART.toString()));
		return ObjUtils.get(result, 0);
	}

	public List<Recommend> findAll() {
		return super.selectList(new WhereBuilder().gt(F_ID, 0));
	}
}

