/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.po.ChnCanSaleProd;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="t_op_chn_can_sale_prod")
public class ChnCanSaleProdDao
extends BaseDao<ChnCanSaleProd> {
    @Autowired
    public ChnCanSaleProdDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<ChnCanSaleProd> getChannelCodeByProductIdAndChannelCode(Integer productId, String channelCode) {
        return super.selectList(new WhereBuilder("PRODUCT_ID", (Object)productId).eq("CHANNEL_CODE", (Object)channelCode));
    }

    public List<ChnCanSaleProd> getChannelCodeByProductId(Integer productId) {
        return super.selectList(new WhereBuilder("PRODUCT_ID", (Object)productId));
    }

    public ChnCanSaleProd getById(Integer id) {
        return (ChnCanSaleProd)super.selectOne(new WhereBuilder("id", (Object)id));
    }

    public ChnCanSaleProd byProductIdAndSkuCode(Integer productId, String skuCode) {
        WhereBuilder wb = new WhereBuilder("PRODUCT_ID", (Object)productId).eq("ON_SHELF", (Object)1).eq("CHANNEL_CODE", (Object)"CHN2018").like("CAN_SALE_SKU", (Object)skuCode).like("CAN_SEE_SKU", (Object)skuCode);
        return (ChnCanSaleProd)super.selectOne(wb);
    }

    public ChnCanSaleProd byChannelCodeAndProductId(String channelCode, Integer productId) {
        return (ChnCanSaleProd)super.selectOne(new WhereBuilder("CHANNEL_CODE", (Object)channelCode).eq("PRODUCT_ID", (Object)productId));
    }

    public void downByProductId(Integer productId) {
        super.update(new UpdateBuilder().updateEq("ON_SHELF", (Object)0).whereEq("PRODUCT_ID", (Object)productId));
    }

    public void updateOnshelfById(Integer id, ChnCanSaleProd.OnShelf onshelf) {
        super.update(new UpdateBuilder().updateEq("ON_SHELF", (Object)onshelf.value).whereEq("id", (Object)id));
    }

    public List<Map> listProdUpDown(Map params) {
        Integer page = MapUtils.getInteger((Map)params, (Object)"page", (Integer)1);
        Integer size = MapUtils.getInteger((Map)params, (Object)"size", (Integer)20);
        if (page > 0) {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page - 1);
        }
        int start = page * size;
        params.put("start", start);
        return super.selectList("listProdUpDown", (Object)params);
    }

    public List<Map> listProdUpDownApproval(Map params) {
        Integer page = MapUtils.getInteger((Map)params, (Object)"page", (Integer)1);
        Integer size = MapUtils.getInteger((Map)params, (Object)"size", (Integer)20);
        if (page > 0) {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page - 1);
        }
        int start = page * size;
        params.put("start", start);
        return super.selectList("listProdUpDownApproval", (Object)params);
    }
}

