package com.thebeastshop.scm.dao;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.ProductUpDownTimer;

import static com.thebeastshop.scm.po.ProductUpDownTimer.*;

@DaoConfig(table = "t_op_product_up_down_timer")
public class ProductUpDownTimerDao extends BaseDao<ProductUpDownTimer>{
	
	@Autowired
	public ProductUpDownTimerDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public List<ProductUpDownTimer> byBeforeNow(){
		WhereBuilder wb = new WhereBuilder()
			.lte(F_TIMER_OPER_TIME, new DateTime().toString("yyyy-MM-dd HH:mm:ss")).eq(F_IS_VALID, 0)
			.orderAsc(F_TIMER_OPER_TIME);
		return super.selectList(wb);
	}
	
}