/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.dao.ScmBaseDao;
import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import com.thebeastshop.scm.po.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;

@DaoConfig(table="t_op_attribute")
public class AttributeDao
extends ScmBaseDao<Attribute> {
    @Autowired
    public AttributeDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsAttributeVO> getEsByProductId(Long productId) {
        List<Map> list = super.selectList("getEsByProductId", (Object)productId);
        list = this.convergeMapList(list, this.primaryKeyName);
        ArrayList<PsAttributeVO> result = new ArrayList<PsAttributeVO>();
        for (Map attributeMap : list) {
            PsAttributeVO attributeVo = new PsAttributeVO(attributeMap);
            result.add(attributeVo);
        }
        return result;
    }

    public Map<Integer, List<PsAttributeVO>> getEsByProductIdAll() {
        HashMap<Integer, List<PsAttributeVO>> mapResult = new HashMap<Integer, List<PsAttributeVO>>();
        List listAll = super.selectList("getEsByProductIdAll");
        HashMap<Integer, ArrayList<Map>> productIdMap = new HashMap<Integer, ArrayList<Map>>();
        for (Map map : listAll) {
            if (map.get("productId") == null) continue;
            Integer productId = Integer.valueOf(map.get("productId").toString());
            ArrayList<Map> lstTemp = (ArrayList<Map>)productIdMap.get(productId);
            if (lstTemp == null) {
                lstTemp = new ArrayList<Map>();
                productIdMap.put(productId, lstTemp);
            }
            lstTemp.add(map);
        }
        for (Map.Entry entry : productIdMap.entrySet()) {
            List<Map> list = (List<Map>)entry.getValue();
            list = this.convergeMapList(list, this.primaryKeyName);
            ArrayList<PsAttributeVO> listResult = new ArrayList<PsAttributeVO>();
            for (Map attributeMap : list) {
                PsAttributeVO attributeVo = new PsAttributeVO(attributeMap);
                listResult.add(attributeVo);
            }
            mapResult.put((Integer)entry.getKey(), (List<PsAttributeVO>)listResult);
        }
        return mapResult;
    }

    public List<PsAttributeValuePairVO> findPairByIds(List<Long> ids) {
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("ids", ids);
        List<Map> list = super.selectList("findPairByIds", params);
        list = this.convergeMapList(list, this.primaryKeyName);
        ArrayList<PsAttributeValuePairVO> result = new ArrayList<PsAttributeValuePairVO>();
        for (Map attributePairMap : list) {
            PsAttributeValuePairVO attributeValuePairVo = new PsAttributeValuePairVO(attributePairMap);
            result.add(attributeValuePairVo);
        }
        return result;
    }
}

