package com.thebeastshop.scm.dao;

import java.util.List;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SoPackage;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_op_so_package")
public class SoPackageDao extends BaseDao<SoPackage>{
	
	@Autowired
	public SoPackageDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 根据订单号查询包裹信息
	 * @param soId
	 * @return
	 */
	public List<SoPackage> findSoPackageBySoId(Integer soId){
		WhereBuilder whereBuilder = new WhereBuilder();
		whereBuilder.eq("SALES_ORDER_ID", soId);
		return super.selectList(whereBuilder);
	}
}