package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.Product.*;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.po.Product;

@DaoConfig(table = "t_op_product")
public class ProductDao extends BaseDao<Product>{
	
	@Autowired
	public ProductDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	public Product byCode(String code){
		return super.selectOne(new WhereBuilder(F_CODE, code));
	}

	public List<Product> byProductIds(List<Integer> productIds){
		return super.selectList(new WhereBuilder().in(F_ID, productIds));
	}

	public List<String> getSkuCodesById(Integer id) {
		return super.selectList("getSkuCodeById", id);
	}

	public List<String> getBarCodesBySkuCodes(List<String> skuCodes) {
		return super.selectList("getBarCodesBySkuCodes", skuCodes);
	}
	
	public List<PsProductVO> getPsProductVOByIds(List<Integer> ids){
		return super.selectList("getPsProductVOByIds", ids);
	}

	public PsProductVO getPsProductVOById(Integer id){
		return super.selectOne("getPsProductVOByIds", Lists.newArrayList(id));
	}


	public List<Integer> getAllProductId(){
		return super.selectFieldList("id", new WhereBuilder().gte("id", 0).orderDesc("id"));
	}
	
	/**
	 * 查找所有新官网的上架的商品productId和skucode
	 * @return
	 */
	public List<Map> getAllProductIdAndSkuCodeByOnShelf(){
		return super.selectList("getAllIdAndSkuCodeByOnShelf");
	}

	/**
	 * 根据Product ID查询后端类目ID
	 * @param productId
	 * @return
     */
	public Long getCategoryIdByProductId(Long productId) {
		return super.selectOne("getCategoryIdByProductId", productId);
	}
	
	/**
	 * 定时自动下架EMAIl内容
	 * @return
	 */
	public List<Map> mailContentByIds(List<Integer> productIds){
		return super.selectList("mailContentByIds", productIds);
	}
	
	/**
	 * PROD维护页面
	 */
	public List<Map> listProdMat(Map params){
		Integer page = MapUtils.getInteger(params, "page", 1);
		Integer size = MapUtils.getInteger(params, "size" , 20);
		if (page > 0) {
			page -- ;
		}
		int start = page * size;
		params.put("start", start);
		return super.selectList("listProdMat", params);
	}
	
	/**
	 * 是否来单制作
	 * @return ture:来单制作 false:不是来单制作
	 */
	public boolean isJitById(Integer productId){
		Integer result = super.selectOne("isJitById", productId);
		return result != null;
	}

	/**
	 * 是否定制
	 * @return ture:定制 false:非定制
	 */
	public boolean isCustomizeById(Integer productId){
		Integer result = super.selectOne("isCustomizeById", productId);
		return result != null;
	}

	/**
	 * @return 商品ID
	 */
	public List<Integer> getJitCustomizeProductId(){
		List<Integer> result = super.selectList("getJitCustomizeProductId");
		return result;
	}

	/**
	 * @return 折扣商品ID
	 */
	public List<Integer> getDiscountProductId(){
		List<Integer> result = super.selectList("getDiscountProductId");
		return result;
	}

	public Boolean findByDiscountProductId(Integer productId){
		Integer result = super.selectOne("findByDiscountProductId",productId);
		return result != null;
	}
	
	/**
	 * 自动推荐联想输入框
	 */
	public List<Map> autoRecommendAutocomplete(String value){
		return super.selectList("autoRecommendAutocomplete", value);
	}
	
	public Map recommendAutoByProdCode(String prodCode){
		return super.selectOne("recommendAutoByProdCode", prodCode);
	}

	public Integer deleteOpClPsProdRepeatRecords(){
		return super.delete("deleteOpClPsProdRepeatRecords");
	}


	}