package com.thebeastshop.scm.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Presale;

@DaoConfig(table = "t_op_presale")
public class PresaleDao extends BaseDao<Presale>{
	
	@Autowired
	public PresaleDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 得到预售的数量
	 */
	public int getPresaleBySkuCodes(List<String> skuCodes) {
		return super.selectOne("getPresaleBySkuCodes", skuCodes);
	}

	/**
	 * 得到各SKU预售的数量
	 */
	public List<Map<String, Object>> getPresaleMapBySkuCodes(List<String> skuCodes) {
		return super.selectList("getPresaleMapBySkuCodes", skuCodes);
	}


	/**
	 * 判断当时时间是否有预售库存记录
	 */
	public boolean existByProductId(Integer productId) {
		Integer result = super.selectOne("existByProductId", productId);
		return result != null;
	}
	
}