package com.thebeastshop.scm.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.Label;

@DaoConfig(table = "label")
public class LabelDao extends BaseDao<Label>{
	
	@Autowired
	public LabelDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}
	
	/**
	 * 查找es中的需要的数据按productId
	 */
	public List<Map> getEsLabelByProductId(Integer productId) {
		return super.selectList("getEsLabelByProductId", productId);
	}

	/**
	 * 查找es中的海淘标签按productId
	 */
	public List<Map> getCrossBoederEsLabelByProductId(Integer productId) {
		return super.selectList("getCrossBoederEsLabelByProductId", productId);
	}

	/**
	 * 查找es中的活动标签按productId
	 */
	public List<Map> getCampaignEsLabelByProductId(Integer productId) {
		return super.selectList("getCampaignEsLabelByProductId", productId);
	}

	/**
	 * 查找es中的品牌标签按productId
	 */
	public List<Map> getBrandEsLabelByProductId(Integer productId) {
		return super.selectList("getBrandEsLabelByProductId", productId);
	}

	/**
	 * 查找es中的品牌标签按productId
	 */
	public List<Map> getCategoryEsLabelByProductId(Integer productId) {
		return super.selectList("getCategoryEsLabelByProductId", productId);
	}

}