package com.thebeastshop.scm.dao;

import static com.thebeastshop.scm.po.LotteryActivityAwardType.*;

import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

import com.thebeastshop.scm.po.LotteryActivityAwardType;

@DaoConfig(table = "lottery_activity_award_type")
public class LotteryActivityAwardTypeDao extends BaseDao<LotteryActivityAwardType>{
	
	@Autowired
	public LotteryActivityAwardTypeDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	public List<String> getTypeByAwardId(Integer awardId) {
		return this.selectFieldList(F_TYPE, new WhereBuilder(F_LOTTERY_ACTIVITY_AWARD_ID, awardId).orderAsc(F_TYPE));
	}

	public void save(List<LotteryActivityAwardType> lotteryActivityAwardTypeList) {
		if (CollectionUtils.isEmpty(lotteryActivityAwardTypeList)) {
			return;
		}
		super.delete(new WhereBuilder(F_LOTTERY_ACTIVITY_AWARD_ID, lotteryActivityAwardTypeList.get(0).getLotteryActivityAwardId()));
		super.insertBatch(lotteryActivityAwardTypeList);
	}
	
}