/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.cond.InterestFreeCond;
import com.thebeastshop.scm.po.InterestFreeProvide;
import com.thebeastshop.scm.vo.interest.InterestFreeProvideVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.UpdateBuilder;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="interest_free_provide")
public class InterestFreeProvideDao
extends BaseDao<InterestFreeProvide> {
    @Autowired
    public InterestFreeProvideDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<InterestFreeProvideVO> selectProvideRecord(InterestFreeCond cond) {
        return super.selectList("queryRecordByInterestFreeId", (Object)cond.toMap());
    }

    public int changeMember(Integer sourceMemberId, Integer targetMemberId) {
        return super.update(new UpdateBuilder().updateEq("member_id", (Object)targetMemberId).whereEq("member_id", (Object)sourceMemberId));
    }

    public int countReceive(Integer interestFreeId) {
        return super.count(new WhereBuilder().eq("interest_free_id", (Object)interestFreeId));
    }

    public int countReceiveByMember(Integer interestFreeId, Integer memberId) {
        return super.count(new WhereBuilder().eq("interest_free_id", (Object)interestFreeId).eq("member_id", (Object)memberId));
    }

    public int updateUsedNum(Integer provideId, Integer usedNum) {
        UpdateBuilder update = new UpdateBuilder();
        update.updateIncr("used_num");
        update.updateEq("update_time", (Object)new Date());
        WhereBuilder where = new WhereBuilder();
        where.eq("id", (Object)provideId).eq("used_num", (Object)usedNum);
        update.setWhereBuilder(where);
        return super.update(update);
    }

    public int backInterestFree(Integer provideId) {
        return super.update("updateBackUsedNum", (Object)provideId);
    }

    public int selectMaxUsedNum(Integer interestFreeId) {
        return (Integer)super.selectOne("selectMaxUsedNum", (Object)interestFreeId);
    }

    public int selectSignMaxReceiveNum(Integer interestFreeId) {
        return (Integer)super.selectOne("selectSignMaxReceiveNum", (Object)interestFreeId);
    }

    public int checkReceiveCurMonth(Integer interestFreeId, Integer memberId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("interestFreeId", interestFreeId);
        map.put("memberId", memberId);
        return (Integer)super.selectOne("checkReceiveCurMonth", map);
    }
}

