/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.po.Product;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table="t_op_product")
public class ProductDao
extends BaseDao<Product> {
    @Autowired
    public ProductDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public Product byCode(String code) {
        return (Product)super.selectOne(new WhereBuilder("CODE", (Object)code));
    }

    public List<Product> byProductIds(List<Integer> productIds) {
        return super.selectList(new WhereBuilder().in("id", productIds));
    }

    public List<String> getSkuCodesById(Integer id) {
        return super.selectList("getSkuCodeById", (Object)id);
    }

    public List<PsProductVO> getPsProductVOByIds(List<Integer> ids) {
        return super.selectList("getPsProductVOByIds", ids);
    }

    public List<Integer> getAllProductId() {
        return super.selectFieldList("id", new WhereBuilder().gte("id", (Object)0));
    }

    public List<Map> getAllProductIdAndSkuCodeByOnShelf() {
        return super.selectList("getAllIdAndSkuCodeByOnShelf");
    }

    public List<Map> mailContentByIds(List<Integer> productIds) {
        return super.selectList("mailContentByIds", productIds);
    }

    public List<Map> listProdMat(Map params) {
        Integer page = MapUtils.getInteger((Map)params, (Object)"page", (Integer)1);
        Integer size = MapUtils.getInteger((Map)params, (Object)"size", (Integer)20);
        if (page > 0) {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page - 1);
        }
        int start = page * size;
        params.put("start", start);
        return super.selectList("listProdMat", (Object)params);
    }

    public boolean isJitById(Integer productId) {
        Integer result = (Integer)super.selectOne("isJitById", (Object)productId);
        return result != null;
    }
}

