package com.thebeastshop.scm.dao;

import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.thebeastshop.scm.po.SmsSendLog;

import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.dao.BaseDao;

@DaoConfig(table = "t_sms_send_log")
public class SmsSendLogDao extends BaseDao<SmsSendLog>{

	@Autowired
	public SmsSendLogDao(@Qualifier("scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		super(sqlSessionFactory);
	}

	/**
	 * 获取最近一条会员生日短信信息(包含'生日'两字,status = 0的)
	 * @param mobile
	 * @return
	 */
	public SmsSendLog getLastBirthDayContentByMobile(String mobile){
		return super.selectOne("getLastBirthDayContentByMobile",mobile);
	}
}