/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.scm.dao;

import com.thebeastshop.scm.es.PsDynmContentVO;
import com.thebeastshop.scm.po.ProdDynmCont;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pers.richard.ormybatis.annotation.DaoConfig;
import pers.richard.ormybatis.builder.WhereBuilder;
import pers.richard.ormybatis.dao.BaseDao;
import pers.richard.ormybatis.domain.po.IdPo;

@DaoConfig(table="t_op_prod_dynm_cont")
public class ProdDynmContDao
extends BaseDao<ProdDynmCont> {
    @Autowired
    public ProdDynmContDao(@Qualifier(value="scmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public List<PsDynmContentVO> getMapByProdId(Integer productId) {
        return super.selectList("getPsDynmContentVOByProdId", (Object)productId);
    }

    public void saveByProdCodeAndType(Integer productId, String content, Integer contentTypeIndex) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        ProdDynmCont.ContentType contentType = ProdDynmCont.ContentType.values()[contentTypeIndex - 1];
        ProdDynmCont prodDynmCont = new ProdDynmCont();
        prodDynmCont.setProductId(productId);
        prodDynmCont.setContent(content);
        prodDynmCont.setSort(contentTypeIndex);
        prodDynmCont.setContentType(contentType.getType());
        prodDynmCont.setTitleCn(contentType.getNameCn());
        prodDynmCont.setTitleEn(contentType.getNameEn());
        super.insertOrUpdate((IdPo)prodDynmCont, new WhereBuilder("PRODUCT_ID", (Object)productId).eq("CONTENT_TYPE", (Object)contentType.getType()));
    }
}

