/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.redis.serializer.core;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class AbstractSerializer<T>
implements RedisSerializer<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return null;
        }
        Schema schema = RuntimeSchema.getSchema(t.getClass());
        return ProtostuffIOUtil.toByteArray(t, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate((int)512));
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        Type type = this.getClass().getGenericSuperclass();
        Type[] p = ((ParameterizedType)type).getActualTypeArguments();
        Class clz = (Class)p[0];
        T po = null;
        try {
            po = clz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.error(null, (Throwable)e);
        }
        ProtostuffIOUtil.mergeFrom((byte[])bytes, po, (Schema)RuntimeSchema.getSchema((Class)clz));
        return po;
    }
}

