/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.web.util.mvc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private static final Logger log = LoggerFactory.getLogger(FastJsonHttpMessageConverter.class);
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private Charset charset = UTF8;
    private SerializerFeature[] serializerFeature;

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        if (this.charset == UTF8) {
            return JSON.parseObject((byte[])bytes, clazz, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((byte[])bytes, (int)0, (int)bytes.length, (CharsetDecoder)this.charset.newDecoder(), clazz, (Feature[])new Feature[0]);
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        block4: {
            OutputStream out = null;
            try {
                byte[] bytes;
                out = outputMessage.getBody();
                if (this.charset == UTF8) {
                    bytes = this.serializerFeature != null ? JSON.toJSONBytes((Object)obj, (SerializerFeature[])this.serializerFeature) : JSON.toJSONBytes((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect});
                } else {
                    String text = this.serializerFeature != null ? JSON.toJSONString((Object)obj, (SerializerFeature[])this.serializerFeature) : JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
                    bytes = text.getBytes(this.charset);
                }
                out.write(bytes);
                out.flush();
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
                if (out == null) break block4;
                out.close();
            }
        }
    }
}

