/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.web.response;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ResponseVO
implements Serializable {
    private static final long serialVersionUID = 4807318268209609704L;
    public static final Meta SUCCESS = new Meta(0, "success");
    public static final Meta FAILURE = new Meta(1, "failure");
    private Meta meta;
    private Result result;

    public ResponseVO() {
    }

    public static ResponseVO success() {
        return new ResponseVO(SUCCESS, null);
    }

    public static <T> ResponseVO success(T data) {
        return new ResponseVO(SUCCESS, new Result(data, null));
    }

    public static <T> ResponseVO success(T data, Integer currentPage, Integer pageSize, Integer totalCount) {
        return new ResponseVO(SUCCESS, data, currentPage, pageSize, totalCount);
    }

    public static ResponseVO failure() {
        return new ResponseVO(FAILURE, null);
    }

    public static ResponseVO failure(int errno, String msg) {
        return new ResponseVO(new Meta(errno, msg), null);
    }

    public static <T> ResponseVO failure(int errno, String msg, T data) {
        return new ResponseVO(new Meta(errno, msg), new Result(data, null));
    }

    private <T> ResponseVO(Meta meta, T data, Integer currentPage, Integer pageSize, Integer totalCount) {
        this.meta = meta;
        if (data != null && currentPage != null && pageSize != null && totalCount != null) {
            this.result = new Result(data, new Page(currentPage, pageSize, totalCount));
        }
    }

    private ResponseVO(Meta meta, Result result) {
        this.meta = meta;
        this.result = result;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(int errno, String msg) {
        this.meta = new Meta(errno, msg);
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("meta", (Object)this.meta).append("result", (Object)this.result).toString();
    }

    public static class Page
    implements Serializable {
        private static final long serialVersionUID = -9015310768471855060L;
        private Integer currentPage;
        private Integer pageSize = 10;
        private Integer totalCount;
        private Integer totalPage = 0;

        private Page() {
        }

        private Page(Integer currentPage, Integer pageSize, Integer totalCount) {
            this.currentPage = currentPage;
            this.pageSize = pageSize;
            this.totalCount = totalCount;
        }

        public void setCurrentPage(Integer currentPage) {
            this.currentPage = currentPage;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentPage() {
            return this.currentPage;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public Integer getTotalPage() {
            if (this.pageSize != null && this.pageSize > 0) {
                this.totalPage = this.totalCount % this.pageSize == 0 ? Integer.valueOf(this.totalCount / this.pageSize) : Integer.valueOf(this.totalCount / this.pageSize + 1);
            }
            return this.totalPage;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("currentPage", (Object)this.currentPage).append("pageSize", (Object)this.pageSize).append("totalCount", (Object)this.totalCount).toString();
        }
    }

    public static class Meta
    implements Serializable {
        private int errno;
        private String msg;

        private Meta() {
        }

        private Meta(int errno, String msg) {
            this.errno = errno;
            this.msg = msg;
        }

        public void setErrno(int errno) {
            this.errno = errno;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }

        public int getErrno() {
            return this.errno;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Meta meta = (Meta)o;
            return new EqualsBuilder().append(this.errno, meta.errno).append((Object)this.msg, (Object)meta.msg).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.errno).append((Object)this.msg).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("errno", this.errno).append("msg", (Object)this.msg).toString();
        }
    }

    public static class Result<T>
    implements Serializable {
        private Page page;
        private T data;

        private Result() {
        }

        private Result(T data, Page page) {
            this.data = data;
            this.page = page;
        }

        public Page getPage() {
            return this.page;
        }

        public void setPage(Page page) {
            this.page = page;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("page", (Object)this.page).append("data", this.data).toString();
        }
    }
}

