/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.api.ApiException;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.taobao.api.response.ItemSkuGetResponse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.service.CommTmallService;
import com.thebeastshop.tmall.dto.NextoneLogisticsWarehouseUpdateResponseDTO;
import com.thebeastshop.tmall.dto.TmallItemQuantitySyncDTO;
import com.thebeastshop.tmall.dto.TmallShipDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundDTO;
import com.thebeastshop.tmall.dto.TmallTbRefundQueryDTO;
import com.thebeastshop.tmall.dto.TmallTbTradeDTO;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service(value="commTmallService")
public class CommTmallServiceImpl
implements CommTmallService {
    private static final Logger log = LoggerFactory.getLogger(CommTmallService.class);
    @Value(value="${tmall.jushita.url}")
    private String tmallJushitaUrl;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public Long getSkuNumIid(String outerId, String sessionKey) throws Exception {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.tmallJushitaUrl + "/items/item/{channelCode}/{skuCode}", Long.class, new Object[]{sessionKey, outerId});
        return (Long)responseEntity.getBody();
    }

    @Override
    public int getSkuQuantity(String outerId, String channelCode, Long numIid) throws Exception {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.tmallJushitaUrl + "/items/{channelCode}/{numIid}/{skuCode}", Integer.class, new Object[]{channelCode, numIid, outerId});
        return (Integer)responseEntity.getBody();
    }

    @Override
    public int getPromotionUmp(String channelCode, Long numIid) throws Exception {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.tmallJushitaUrl + "/items/promotion/{channelCode}/{skuCode}", Integer.class, new Object[]{channelCode, numIid});
        return (Integer)responseEntity.getBody();
    }

    @Override
    public ItemSkuGetResponse taoBaoItemSkuGet(String channelCode, Long skuId, Long numIid, String nick) throws Exception {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.tmallJushitaUrl + "/items/{channelCode}/{skuId}/{numIid}/{nick}", ItemSkuGetResponse.class, new Object[]{channelCode, skuId, numIid, nick});
        return (ItemSkuGetResponse)responseEntity.getBody();
    }

    @Override
    public String synchronizeTmallShip(Long tid, String companyCode, String deliveryCode) throws ApiException {
        TmallShipDTO tmallShipDTO = new TmallShipDTO();
        tmallShipDTO.setTid(tid);
        tmallShipDTO.setCompanyCode(companyCode);
        tmallShipDTO.setDeliveryCode(deliveryCode);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.tmallJushitaUrl + "/trades/synchronizeShip", (Object)tmallShipDTO, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    @Override
    public ItemQuantityUpdateResponse synCommodityStocks(String channelCode, Long numIid, String outerId, long quantity) throws Exception {
        TmallItemQuantitySyncDTO tmallItemQuantitySyncDTO = new TmallItemQuantitySyncDTO();
        tmallItemQuantitySyncDTO.setNumIid(numIid);
        tmallItemQuantitySyncDTO.setOuterId(outerId);
        tmallItemQuantitySyncDTO.setQuantity(quantity);
        tmallItemQuantitySyncDTO.setChannelCode(channelCode);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.tmallJushitaUrl + "/items/synCommodityStocks", (Object)tmallItemQuantitySyncDTO, ItemQuantityUpdateResponse.class, new Object[0]);
        return (ItemQuantityUpdateResponse)responseEntity.getBody();
    }

    @Override
    public Date getTmallOrderPayTimeByTid(Long tid) {
        TmallTbTradeDTO tmallTbTradeDTO = this.getTmallOrderByTid(tid);
        if (EmptyUtil.isEmpty(tmallTbTradeDTO)) {
            return null;
        }
        JSONObject tradeFullinfo = JSON.parseObject((String)tmallTbTradeDTO.getJdpResponse()).getJSONObject("trade_fullinfo_get_response").getJSONObject("trade");
        return tradeFullinfo.getDate("pay_time");
    }

    @Override
    public TmallTbTradeDTO getTmallOrderByTid(Long tid) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.tmallJushitaUrl + "/trades/{tid}", TmallTbTradeDTO.class, new Object[]{tid});
        return (TmallTbTradeDTO)responseEntity.getBody();
    }

    @Override
    public List<TmallTbRefundDTO> getTmallRefunds(Date startDate, Date endDate) throws HttpException, IOException {
        TmallTbRefundQueryDTO tmallTbRefundQueryDTO = new TmallTbRefundQueryDTO();
        tmallTbRefundQueryDTO.setModifiedStart(startDate);
        tmallTbRefundQueryDTO.setModifiedEnd(endDate);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds", (Object)tmallTbRefundQueryDTO, TmallTbRefundDTO[].class, new Object[0]);
        TmallTbRefundDTO[] tmallTbRefundArray = (TmallTbRefundDTO[])responseEntity.getBody();
        if (EmptyUtil.isEmpty(tmallTbRefundArray)) {
            return null;
        }
        return Arrays.asList(tmallTbRefundArray);
    }

    @Override
    public NextoneLogisticsWarehouseUpdateResponseDTO tmallAgWarehouseUpdate(Long refundId, String channelCode) throws ApiException {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.tmallJushitaUrl + "/refunds/tmallAgWarehouseUpdate/{refundId}/{channelCode}", NextoneLogisticsWarehouseUpdateResponseDTO.class, new Object[]{refundId, channelCode});
        return (NextoneLogisticsWarehouseUpdateResponseDTO)responseEntity.getBody();
    }
}

