/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.google.common.collect.Lists;
import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.domain.ware.SkuReadService.Sku;
import com.jd.open.api.sdk.domain.ware.StockReadService.SkuStock;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.ware.SkuReadSearchSkuListRequest;
import com.jd.open.api.sdk.request.ware.StockReadFindSkuStockRequest;
import com.jd.open.api.sdk.request.ware.StockWriteUpdateSkuStockRequest;
import com.jd.open.api.sdk.response.ware.SkuReadSearchSkuListResponse;
import com.jd.open.api.sdk.response.ware.StockReadFindSkuStockResponse;
import com.jd.open.api.sdk.response.ware.StockWriteUpdateSkuStockResponse;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.exception.UtilException;
import com.thebeastshop.pegasus.util.service.CommJdService;
import com.thebeastshop.pegasus.util.vo.JdAppCfgVO;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="commJdService")
public class CommJdServiceImpl
implements CommJdService {
    private static final String SERVER_URL = "https://api.jd.com/routerjson";
    private static final String OK = "0";
    private static final String JD_WH = "WH020600010195";
    private static final String JD_HOME_WH = "WH000332910332";
    private static final Map<String, String> whChannelMap = new HashMap<String, String>();

    @Override
    public boolean needSyncStock(String warehouseCode) {
        return JD_WH.equals(warehouseCode) || JD_HOME_WH.equals(warehouseCode);
    }

    @Override
    public Map<String, JdStockSyncResult> syncSkuStock(String warehouseCode, Map<String, Integer> skuQuantityMap) {
        HashMap<String, JdStockSyncResult> resultMap = new HashMap<String, JdStockSyncResult>();
        if (!this.needSyncStock(warehouseCode) || skuQuantityMap.isEmpty()) {
            return resultMap;
        }
        JdAppCfgVO appCfg = this.getAppCfg(warehouseCode);
        String channelCode = this.getChannelCode(warehouseCode);
        JdClient jdClient = this.getJdClient(appCfg);
        Map<String, Sku> jdSkuMap = this.searchJdSkuList(jdClient, skuQuantityMap.keySet());
        for (Map.Entry<String, Integer> entry : skuQuantityMap.entrySet()) {
            Sku jdSku = jdSkuMap.get(entry.getKey());
            JdStockSyncResult syncResult = new JdStockSyncResult();
            syncResult.setSkuCode(entry.getKey());
            syncResult.setQuantity(entry.getValue());
            syncResult.setChannelCode(channelCode);
            resultMap.put(entry.getKey(), syncResult);
            if (NullUtil.isNotNull(jdSku)) {
                if (entry.getValue() == 0) {
                    syncResult.setSuccess(true);
                    continue;
                }
                syncResult.setJdSkuId(jdSku.getSkuId());
                Long jdStockNum = this.getJdSkuStock(jdClient, jdSku);
                if (NullUtil.isNotNull(jdStockNum)) {
                    jdSku.setStockNum(Long.valueOf(jdStockNum + (long)entry.getValue().intValue()));
                    String errorMsg = this.updateJdSkuStock(jdClient, jdSku);
                    if (errorMsg != null) {
                        syncResult.setErrorMsg(errorMsg);
                        continue;
                    }
                    syncResult.setSuccess(true);
                    continue;
                }
                syncResult.setErrorMsg("\u83b7\u53d6SKU\u5e93\u5b58\u5931\u8d25");
                continue;
            }
            syncResult.setErrorMsg("\u4eac\u4e1c\u4e0d\u5b58\u5728\u8be5SKU");
        }
        return resultMap;
    }

    private String updateJdSkuStock(JdClient client, Sku jdSku) {
        StockWriteUpdateSkuStockRequest request = new StockWriteUpdateSkuStockRequest();
        request.setSkuId(jdSku.getSkuId());
        request.setStockNum(jdSku.getStockNum());
        if (jdSku.getStockNum() < 0L) {
            return "\u5e93\u5b58\u4e0d\u8db3";
        }
        try {
            StockWriteUpdateSkuStockResponse response = (StockWriteUpdateSkuStockResponse)client.execute((JdRequest)request);
            if (OK.equals(response.getCode()) && response.getSuccess()) {
                return null;
            }
            return response.getZhDesc();
        }
        catch (JdException e) {
            throw new UtilException("CO0001", e.getMessage());
        }
    }

    private Long getJdSkuStock(JdClient client, Sku jdSku) {
        StockReadFindSkuStockRequest request = new StockReadFindSkuStockRequest();
        request.setSkuId(jdSku.getSkuId());
        try {
            StockReadFindSkuStockResponse response = (StockReadFindSkuStockResponse)client.execute((JdRequest)request);
            if (OK.equals(response.getCode())) {
                List skuStockList = response.getSkuStocks();
                if (EmptyUtil.isNotEmpty(skuStockList)) {
                    return ((SkuStock)skuStockList.get(0)).getStockNum();
                }
                return null;
            }
            throw new UtilException("CO0001", "\u83b7\u53d6\u5e93\u5b58\u5931\u8d25!");
        }
        catch (JdException e) {
            throw new UtilException("CO0001", e.getMessage());
        }
    }

    public Map<String, Sku> searchJdSkuList(JdClient client, Set<String> skuCodes) {
        if (EmptyUtil.isEmpty(skuCodes)) {
            throw new UtilException("CO0001", "SKU\u4e3a\u7a7a");
        }
        List<String> codesList = Arrays.asList(skuCodes.toArray(new String[skuCodes.size()]));
        HashMap<String, Sku> skuMap = new HashMap<String, Sku>();
        List parts = Lists.partition(codesList, (int)19);
        for (List part : parts) {
            Map<String, Sku> tmpMap = this.searchJdSkuListPage(client, part);
            skuMap.putAll(tmpMap);
        }
        return skuMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Sku> searchJdSkuListPage(JdClient client, List<String> skuCodes) {
        if (EmptyUtil.isEmpty(skuCodes)) {
            throw new UtilException("CO0001", "SKU\u4e3a\u7a7a");
        }
        int pageNo = 1;
        HashMap<String, Sku> skuMap = new HashMap<String, Sku>();
        ArrayList rtList = new ArrayList();
        while (true) {
            SkuReadSearchSkuListRequest request = new SkuReadSearchSkuListRequest();
            request.setSkuStatuValue("1,2");
            String outId = StringUtils.join(skuCodes, (String)",");
            request.setOutId(outId);
            request.setPageNo(Integer.valueOf(pageNo));
            request.setPageSize(Integer.valueOf(100));
            try {
                SkuReadSearchSkuListResponse response = (SkuReadSearchSkuListResponse)client.execute((JdRequest)request);
                if (!OK.equals(response.getCode())) {
                    throw new UtilException("CO0002", response.getZhDesc());
                }
                List jdSkuList = response.getPage().getData();
                if (EmptyUtil.isNotEmpty(jdSkuList)) {
                    rtList.addAll(jdSkuList);
                }
                if ((long)rtList.size() == response.getPage().getTotalItem()) break;
                pageNo = response.getPage().getPageNo();
                ++pageNo;
            }
            catch (JdException e) {
                throw new UtilException("CO0001", e.getMessage());
            }
        }
        Collections.sort(rtList, new Comparator<Sku>(){

            @Override
            public int compare(Sku o1, Sku o2) {
                return o1.getStatus().compareTo(o2.getStatus());
            }
        });
        Iterator i$ = rtList.iterator();
        while (i$.hasNext()) {
            Sku jdSku = (Sku)i$.next();
            Sku tmp = (Sku)skuMap.get(jdSku.getOuterId());
            if (!NullUtil.isNull(tmp)) continue;
            skuMap.put(jdSku.getOuterId(), jdSku);
        }
        return skuMap;
    }

    private JdClient getJdClient(JdAppCfgVO appCfg) {
        return new DefaultJdClient(SERVER_URL, appCfg.getAccessToken(), appCfg.getAppKey(), appCfg.getAppSecret());
    }

    private JdAppCfgVO getAppCfg(String warehouseCode) {
        JdAppCfgVO appCfg = new JdAppCfgVO();
        if (JD_WH.equals(warehouseCode)) {
            appCfg.setAppKey("CB79069CD881B39EC25CB569053A6B30");
            appCfg.setAppSecret("8e16059ec7264e6ca0a5ea0f81d4326b");
            appCfg.setAccessToken("714e1379-97a8-437b-9fb7-6e1b130b808c");
            appCfg.setRefreshToken("1df4e597-e6dc-4cf0-9466-da72d68046ae");
        } else if (JD_HOME_WH.equals(warehouseCode)) {
            appCfg.setAppKey("BC87A4010848855465B46C723EDA177C");
            appCfg.setAppSecret("8a4c65bac1e94a859ff3b6531cfd8989");
            appCfg.setAccessToken("74734c15-8250-4eb3-a8ad-efd06db81f4d");
            appCfg.setRefreshToken("10cf7285-7bd2-4aa4-a45e-16f0e71bec3f");
        } else {
            throw new UtilException("\u975e\u4eac\u4e1c\u4ed3\u65e0\u9700\u540c\u6b65");
        }
        return appCfg;
    }

    private String getChannelCode(String warehouseCode) {
        return whChannelMap.get(warehouseCode);
    }

    static {
        whChannelMap.put(JD_WH, "CHN2042");
        whChannelMap.put(JD_HOME_WH, "CHN2079");
    }
}

