/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.dao.CommFileRefMapper;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommFileRefExample;
import com.thebeastshop.pegasus.util.service.CommFileRefService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="commFileRefService")
public class CommFileRefServiceImpl
implements CommFileRefService {
    @Autowired
    private CommFileRefMapper commFileRefMapper;

    @Override
    @Transactional
    public void createFile(CommFileRef commFileRef) {
        commFileRef.setCreateTime(DateUtil.getNow());
        commFileRef.setStatus(1);
        this.commFileRefMapper.insert(commFileRef);
    }

    @Override
    public CommFileRef findById(Long id) {
        return this.commFileRefMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<CommFileRef> findByIds(List<Long> ids) {
        CommFileRefExample example = new CommFileRefExample();
        CommFileRefExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)ids);
        return this.findByCond(example);
    }

    @Override
    public List<CommFileRef> findByCond(CommFileRefExample example) {
        return this.commFileRefMapper.selectByExample(example);
    }

    @Override
    public List<CommFileRef> find(String referenceCode, Integer referenceType) {
        CommFileRefExample example = new CommFileRefExample();
        example.createCriteria().andReferenceCodeEqualTo(referenceCode).andRefTypeEqualTo(referenceType);
        return this.commFileRefMapper.selectByExample(example);
    }

    @Override
    public List<CommFileRef> findByCommFileRef(String returnCode, String skuCode) {
        return this.commFileRefMapper.findByCommFileRef(returnCode, skuCode);
    }

    @Override
    public List<CommFileRef> findByCond(CommFileRef commFileRef) {
        CommFileRefExample example = new CommFileRefExample();
        CommFileRefExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(commFileRef.getReferenceCode())) {
            criteria.andReferenceCodeEqualTo(commFileRef.getReferenceCode());
        } else if (CollectionUtils.isNotEmpty(commFileRef.getReferenceCodes())) {
            criteria.andReferenceCodeIn((List)commFileRef.getReferenceCodes());
        }
        if (EmptyUtil.isNotEmpty(commFileRef.getRefType())) {
            criteria.andRefTypeEqualTo(commFileRef.getRefType());
        }
        if (EmptyUtil.isNotEmpty(commFileRef.getReferenceSecondCode())) {
            criteria.andReferenceSecondCodeEqualTo(commFileRef.getReferenceSecondCode());
        }
        if (EmptyUtil.isNotEmpty(commFileRef.getStatus())) {
            criteria.andStatusEqualTo(commFileRef.getStatus());
        }
        return this.commFileRefMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public int deleteById(Long id) {
        CommFileRef update = new CommFileRef();
        update.setDeleteTime(DateUtil.getNow());
        update.setStatus(0);
        update.setId(id);
        return this.commFileRefMapper.updateByPrimaryKeySelective(update);
    }

    @Override
    @Transactional
    public int updateByCond(CommFileRef record, CommFileRefExample example) {
        return this.commFileRefMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Transactional
    public int updateByIdSelective(CommFileRef record) {
        return this.commFileRefMapper.updateByPrimaryKeySelective(record);
    }
}

