/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.dao.CommEntityOpRcdMapper;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcdExample;
import com.thebeastshop.pegasus.util.service.CommEntityOperationRcdService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CommEntityOperationRcdService")
public class CommEntityOperationRcdServiceImpl
implements CommEntityOperationRcdService {
    private final Logger log = LoggerFactory.getLogger(CommEntityOperationRcdServiceImpl.class);
    @Autowired
    private CommEntityOpRcdMapper commEntityOpRcdMapper;

    @Override
    public Long insertRcd(CommEntityOpRcd commEntityOpRcd) {
        commEntityOpRcd.setOperationTime(DateUtil.getNow());
        this.commEntityOpRcdMapper.insert(commEntityOpRcd);
        return commEntityOpRcd.getId();
    }

    @Override
    public List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(String entityName, String entityId) {
        CommEntityOpRcdExample example = new CommEntityOpRcdExample();
        CommEntityOpRcdExample.Criteria criteria = example.createCriteria();
        criteria.andEntityNameEqualTo(entityName);
        criteria.andEntityIdEqualTo(entityId);
        example.setOrderByClause("OPERATION_TIME DESC");
        example.setOrderByClause("ID DESC");
        List<CommEntityOpRcd> rcdList = this.commEntityOpRcdMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(rcdList)) {
            return Collections.emptyList();
        }
        return rcdList;
    }

    @Override
    public List<CommEntityOpRcd> findEntityOpRcdByClazzAndId(Integer operationType, String entityName, String entityId) {
        CommEntityOpRcdExample example = new CommEntityOpRcdExample();
        CommEntityOpRcdExample.Criteria criteria = example.createCriteria();
        criteria.andEntityNameEqualTo(entityName);
        criteria.andEntityIdEqualTo(entityId);
        criteria.andOperationTypeEqualTo(operationType);
        example.setOrderByClause("OPERATION_TIME DESC");
        List<CommEntityOpRcd> rcdList = this.commEntityOpRcdMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(rcdList)) {
            return Collections.emptyList();
        }
        return rcdList;
    }
}

