/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.service.impl;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.cond.CommDictionaryCond;
import com.thebeastshop.pegasus.util.dao.CommCurrencyMapper;
import com.thebeastshop.pegasus.util.dao.CommDictionaryMapper;
import com.thebeastshop.pegasus.util.dao.CommTaxRateMapper;
import com.thebeastshop.pegasus.util.model.CommCurrency;
import com.thebeastshop.pegasus.util.model.CommCurrencyExample;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.model.CommDictionaryExample;
import com.thebeastshop.pegasus.util.model.CommTaxRate;
import com.thebeastshop.pegasus.util.model.CommTaxRateExample;
import com.thebeastshop.pegasus.util.service.CommDictionaryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="commDictionaryService")
public class CommDictionaryServiceImpl
implements CommDictionaryService {
    private final Logger log = LoggerFactory.getLogger(CommDictionaryServiceImpl.class);
    private List<CommCurrency> __cachedCurrencyList;
    private List<CommTaxRate> __cachedTaxRateList;
    private List<CommDictionary> __cachedDicCommodityStatusList;
    @Autowired
    private CommCurrencyMapper commCurrencyMapper;
    @Autowired
    private CommTaxRateMapper commTaxRateMapper;
    @Autowired
    private CommDictionaryMapper commDictionaryMapper;
    private static final String REFRESH_CURRENCY = "refreshCurrency";
    private static final String REFRESH_TAXRATE = "refreshTaxRate";
    private static final String REFRESH_COMMODITY_STATUS = "COMMODITY_STATUS";

    @PostConstruct
    public void init() {
        this.refreshCurrency();
        this.timingRefreshCache(REFRESH_CURRENCY);
        this.refreshTaxRate();
        this.timingRefreshCache(REFRESH_TAXRATE);
        this.timingRefreshCache(REFRESH_COMMODITY_STATUS);
    }

    private void timingRefreshCache(final String refreshFlag) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CommDictionaryServiceImpl.REFRESH_CURRENCY.equals(refreshFlag)) {
                    CommDictionaryServiceImpl.this.refreshCurrency();
                } else if (CommDictionaryServiceImpl.REFRESH_COMMODITY_STATUS.equals(refreshFlag)) {
                    CommDictionaryServiceImpl.this.refreshDicCommodityStatus();
                } else {
                    CommDictionaryServiceImpl.this.refreshTaxRate();
                }
            }
        };
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(runnable, 2L, 6L, TimeUnit.HOURS);
    }

    @Override
    public void refreshCurrency() {
        this.log.info("CommDictionaryService.refreshCurrency start");
        CommCurrencyExample commCurrencyExample = new CommCurrencyExample();
        commCurrencyExample.setOrderByClause("id");
        this.__cachedCurrencyList = this.commCurrencyMapper.selectByExample(commCurrencyExample);
        this.log.info("CommDictionaryService.refreshCurrency finish");
    }

    @Override
    public void refreshTaxRate() {
        this.log.info("CommDictionaryService.refreshTaxRate start");
        CommTaxRateExample commTaxRateExample = new CommTaxRateExample();
        commTaxRateExample.setOrderByClause("id");
        this.__cachedTaxRateList = this.commTaxRateMapper.selectByExample(commTaxRateExample);
        this.log.info("CommDictionaryService.refreshTaxRate finish");
    }

    @Override
    public List<CommCurrency> findAllCurrency() {
        ArrayList<CommCurrency> result = new ArrayList<CommCurrency>();
        try {
            for (CommCurrency commCurrency : this.__cachedCurrencyList) {
                CommCurrency _currency = new CommCurrency();
                PropertyUtils.copyProperties((Object)_currency, (Object)commCurrency);
                result.add(_currency);
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CommTaxRate> findAllTaxRate() {
        ArrayList<CommTaxRate> result = new ArrayList<CommTaxRate>();
        try {
            for (CommTaxRate commTaxRate : this.__cachedTaxRateList) {
                if (commTaxRate.getRateType() != 0) continue;
                CommTaxRate _taxRate = new CommTaxRate();
                PropertyUtils.copyProperties((Object)_taxRate, (Object)commTaxRate);
                result.add(_taxRate);
            }
            Collections.sort(result, new Comparator<CommTaxRate>(){

                @Override
                public int compare(CommTaxRate o1, CommTaxRate o2) {
                    if (o1.getOrderIndex() > o2.getOrderIndex()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<CommTaxRate> findTaxRateByType(Integer type) {
        ArrayList<CommTaxRate> result = new ArrayList<CommTaxRate>();
        try {
            for (CommTaxRate commTaxRate : this.__cachedTaxRateList) {
                if (commTaxRate.getRateType() != type) continue;
                CommTaxRate _taxRate = new CommTaxRate();
                PropertyUtils.copyProperties((Object)_taxRate, (Object)commTaxRate);
                result.add(_taxRate);
            }
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
        }
        return result;
    }

    private void refreshDicCommodityStatus() {
        this.log.info("CommDictionaryService.refreshDicCommodityStatus start");
        CommDictionaryCond cond = new CommDictionaryCond();
        cond.setDictType(REFRESH_COMMODITY_STATUS);
        cond.setOrderBy(" DICT_ORDER ASC ");
        this.__cachedDicCommodityStatusList = this.listDictionaryByCond(cond);
        this.log.info("CommDictionaryService.refreshDicCommodityStatus finish");
    }

    @Override
    public List<CommDictionary> findDicCommodityStatus() {
        this.log.warn("findDicCommodityStatus...");
        if (EmptyUtil.isNotEmpty(this.__cachedDicCommodityStatusList)) {
            return this.__cachedDicCommodityStatusList;
        }
        this.refreshDicCommodityStatus();
        return this.__cachedDicCommodityStatusList;
    }

    @Override
    public List<CommDictionary> findDictionaryByType(String dictType) {
        return this.commDictionaryMapper.findDictionaryByType(dictType);
    }

    @Override
    public List<CommDictionary> findDictionaryByCond(CommDictionaryCond cond) {
        return this.commDictionaryMapper.findDictionaryByCond(cond);
    }

    @Override
    public List<CommDictionary> listDictionaryByCond(CommDictionaryCond cond) {
        CommDictionaryExample example = this.buildCommDictionaryExampleByCond(cond);
        return this.commDictionaryMapper.selectByExample(example);
    }

    private CommDictionaryExample buildCommDictionaryExampleByCond(CommDictionaryCond cond) {
        CommDictionaryExample example = new CommDictionaryExample();
        CommDictionaryExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getDictValue())) {
            criteria.andDictValueEqualTo(cond.getDictValue());
        }
        if (EmptyUtil.isNotEmpty(cond.getDictType())) {
            criteria.andDictTypeEqualTo(cond.getDictType());
        }
        if (EmptyUtil.isNotEmpty(cond.getOrderBy())) {
            example.setOrderByClause(cond.getOrderBy());
        }
        return example;
    }

    @Override
    public String findExpressCodeByExpressName(String ExpressName) {
        return this.commDictionaryMapper.findExpressCodeByExpressName(ExpressName);
    }

    @Override
    public Map<String, String> getCommDictionaryMap(String dictType) {
        HashMap<String, String> dictMap = new HashMap<String, String>();
        List<CommDictionary> commDictionaryList = this.findDictionaryByType(dictType);
        int dictTotal = commDictionaryList.size();
        for (int i = 0; i < dictTotal; ++i) {
            dictMap.put(commDictionaryList.get(i).getDictValue(), commDictionaryList.get(i).getDictName());
        }
        return dictMap;
    }

    @Override
    public int batchInsert(List<CommDictionary> commDictionaries) {
        return this.commDictionaryMapper.batchInsert(commDictionaries);
    }
}

