/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.route;

import com.thebeastshop.pegasus.util.route.ScmSpringManagedTransactionFactory;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class ScmSqlSessionUtils {
    private static final Log logger = LogFactory.getLog(ScmSqlSessionUtils.class);

    private ScmSqlSessionUtils() {
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return ScmSqlSessionUtils.getSqlSession(sessionFactory, executorType, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)sessionFactory, (String)"No SqlSessionFactory specified");
        Assert.notNull((Object)executorType, (String)"No ExecutorType specified");
        SqlSessionHolder holder = (SqlSessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (holder != null && holder.isSynchronizedWithTransaction()) {
            if (holder.getExecutorType() != executorType) {
                throw new TransientDataAccessResourceException("Cannot change the ExecutorType when there is an existing transaction");
            }
            holder.requested();
            if (!logger.isDebugEnabled()) return holder.getSqlSession();
            logger.debug("Fetched SqlSession [" + holder.getSqlSession() + "] from current transaction");
            return holder.getSqlSession();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a new SqlSession");
        }
        SqlSession session = sessionFactory.openSession(executorType);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Environment environment = sessionFactory.getConfiguration().getEnvironment();
            if (environment.getTransactionFactory() instanceof ScmSpringManagedTransactionFactory) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Registering transaction synchronization for SqlSession [" + session + "]");
                }
                holder = new SqlSessionHolder(session, executorType, exceptionTranslator);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)holder);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SqlSessionSynchronization(holder, sessionFactory));
                holder.setSynchronizedWithTransaction(true);
                holder.requested();
                return session;
            } else {
                if (TransactionSynchronizationManager.getResource((Object)environment.getDataSource()) != null) throw new TransientDataAccessResourceException("SqlSessionFactory must be using a SpringManagedTransactionFactory in order to use Spring transaction synchronization");
                if (!logger.isDebugEnabled()) return session;
                logger.debug("SqlSession [" + session + "] was not registered for synchronization because DataSource is not transactional");
            }
            return session;
        } else {
            if (!logger.isDebugEnabled()) return session;
            logger.debug("SqlSession [" + session + "] was not registered for synchronization because synchronization is not active");
        }
        return session;
    }

    public static void closeSqlSession(SqlSession session, SqlSessionFactory sessionFactory) {
        Assert.notNull((Object)session, (String)"No SqlSession specified");
        Assert.notNull((Object)sessionFactory, (String)"No SqlSessionFactory specified");
        SqlSessionHolder holder = (SqlSessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (holder != null && holder.getSqlSession() == session) {
            if (logger.isDebugEnabled()) {
                logger.debug("Releasing transactional SqlSession [" + session + "]");
            }
            holder.released();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing non transactional SqlSession [" + session + "]");
            }
            session.close();
        }
    }

    public static boolean isSqlSessionTransactional(SqlSession session, SqlSessionFactory sessionFactory) {
        Assert.notNull((Object)session, (String)"No SqlSession specified");
        Assert.notNull((Object)sessionFactory, (String)"No SqlSessionFactory specified");
        SqlSessionHolder holder = (SqlSessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        return holder != null && holder.getSqlSession() == session;
    }

    private static final class SqlSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SqlSessionHolder holder;
        private final SqlSessionFactory sessionFactory;

        public SqlSessionSynchronization(SqlSessionHolder holder, SqlSessionFactory sessionFactory) {
            Assert.notNull((Object)holder, (String)"Parameter 'holder' must be not null");
            Assert.notNull((Object)sessionFactory, (String)"Parameter 'sessionFactory' must be not null");
            this.holder = holder;
            this.sessionFactory = sessionFactory;
        }

        public int getOrder() {
            return 999;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)this.holder);
        }

        public void beforeCommit(boolean readOnly) {
            if (this.holder.getExecutorType() == ExecutorType.BATCH && TransactionSynchronizationManager.isActualTransactionActive()) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Transaction synchronization flushing SqlSession [" + this.holder.getSqlSession() + "]");
                    }
                    this.holder.getSqlSession().flushStatements();
                }
                catch (PersistenceException p) {
                    DataAccessException translated;
                    if (this.holder.getPersistenceExceptionTranslator() != null && (translated = this.holder.getPersistenceExceptionTranslator().translateExceptionIfPossible((RuntimeException)((Object)p))) != null) {
                        throw translated;
                    }
                    throw p;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void afterCompletion(int status) {
            try {
                if (!TransactionSynchronizationManager.isActualTransactionActive()) return;
                switch (status) {
                    case 0: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Transaction synchronization committing SqlSession [" + this.holder.getSqlSession() + "]");
                        }
                        this.holder.getSqlSession().commit();
                        return;
                    }
                    case 1: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Transaction synchronization rolling back SqlSession [" + this.holder.getSqlSession() + "]");
                        }
                        this.holder.getSqlSession().rollback();
                        return;
                    }
                    default: {
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("Transaction synchronization ended with unknown status for SqlSession [" + this.holder.getSqlSession() + "]");
                        return;
                    }
                }
            }
            finally {
                if (!this.holder.isOpen()) {
                    TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Transaction synchronization closing SqlSession [" + this.holder.getSqlSession() + "]");
                        }
                        this.holder.getSqlSession().close();
                    }
                    finally {
                        this.holder.reset();
                    }
                }
            }
        }
    }
}

