/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.importExcel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CreatRowTest {
    private String excelPath = "D:\\develop\\\u6587\u6863\\\u4e70\u624b\u4f18\u5316\\RD7650_\u91c7\u8d2d\u5355\u76f8\u5173\u5355\u636e\u4e0b\u8f7d\\PO\u6700\u7ec8\u7248 20180822.xlsx";
    private int insertStartPointer = 3;
    private String sheetName = "PO";

    public static void main(String[] args) {
        CreatRowTest crt = new CreatRowTest();
        crt.insertCells();
    }

    public void insertRows() {
        XSSFWorkbook wb = this.returnWorkBookGivenFileHandle();
        XSSFSheet sheet1 = wb.getSheet(this.sheetName);
        XSSFRow row = this.createRow(sheet1, this.insertStartPointer);
        this.createCell(row);
        this.saveExcel(wb);
    }

    public void insertCells() {
        XSSFWorkbook wb = this.returnWorkBookGivenFileHandle();
        XSSFSheet sheet1 = wb.getSheet(this.sheetName);
        XSSFRow row = this.getRow(sheet1, 1);
        this.createCell(row);
        this.saveExcel(wb);
    }

    private void saveExcel(XSSFWorkbook wb) {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.excelPath);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private XSSFCell createCell(XSSFRow row) {
        XSSFCell cell = row.createCell(0);
        cell.setCellValue(999999.0);
        row.createCell(1).setCellValue(1.2);
        row.createCell(2).setCellValue("This is a string cell");
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSSFWorkbook returnWorkBookGivenFileHandle() {
        XSSFWorkbook wb = null;
        FileInputStream fis = null;
        File f = new File(this.excelPath);
        try {
            if (f != null) {
                fis = new FileInputStream(f);
                wb = new XSSFWorkbook((InputStream)fis);
            }
        }
        catch (Exception e) {
            XSSFWorkbook xSSFWorkbook = null;
            return xSSFWorkbook;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return wb;
    }

    private XSSFRow createRow(XSSFSheet sheet, Integer rowIndex) {
        XSSFRow row = null;
        if (sheet.getRow(rowIndex.intValue()) != null) {
            int lastRowNo = sheet.getLastRowNum();
            sheet.shiftRows(rowIndex.intValue(), lastRowNo, 1);
        }
        row = sheet.createRow(rowIndex.intValue());
        return row;
    }

    private XSSFRow getRow(XSSFSheet sheet, Integer rowIndex) {
        return sheet.getRow(rowIndex.intValue());
    }
}

