/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.enums;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum AccessWayTypeEnum {
    PC(1, "online"),
    APP(2, "online"),
    WAP(3, "online"),
    OFFLINE(4, "offline"),
    LITTLE_B(5, "offline"),
    APPLET(6, "online"),
    HOME_SHOP(7, "offline"),
    TBH_SHOP(8, "offline"),
    POP_SHOP(9, "offline");

    private Integer code;
    private String name;

    private AccessWayTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static AccessWayTypeEnum getEnumByCode(Integer code) {
        for (AccessWayTypeEnum e : AccessWayTypeEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static Map<String, String> getEnumByCode() {
        HashMap maps = Maps.newHashMap();
        for (AccessWayTypeEnum e : AccessWayTypeEnum.values()) {
            maps.put(String.valueOf(e.getCode()), e.getName());
        }
        return maps;
    }

    public static boolean checkAccessOnline(Integer code) {
        return "online".equals(AccessWayTypeEnum.getNameByCode(code));
    }

    public static String getNameByCode(Integer code) {
        AccessWayTypeEnum accessWayEnum = AccessWayTypeEnum.getEnumByCode(code);
        return accessWayEnum != null ? accessWayEnum.getName() : "";
    }

    public String toString() {
        return this.getCode().toString();
    }
}

